"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableInputTracker = exports.ChartGridEmbeddableWrapper = void 0;
var _rxjs = require("rxjs");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _change_points_table = require("../components/change_point_detection/change_points_table");
var _use_reload = require("../hooks/use_reload");
var _change_point_detection_context = require("../components/change_point_detection/change_point_detection_context");
var _use_filters_query = require("../hooks/use_filters_query");
var _use_data_source = require("../hooks/use_data_source");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _search_utils = require("../application/utils/search_utils");
var _use_change_point_agg_request = require("../components/change_point_detection/use_change_point_agg_request");
var _charts_grid = require("../components/change_point_detection/charts_grid");
var _no_change_points_warning = require("../components/change_point_detection/no_change_points_warning");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSort = {
  field: 'p_value',
  direction: 'asc'
};
const EmbeddableInputTracker = ({
  input$,
  initialInput,
  reload$,
  onOutputChange,
  onRenderComplete,
  onLoading,
  onError
}) => {
  var _initialInput$lastRel;
  const input = (0, _useObservable.default)(input$, initialInput);
  const [manualReload$] = (0, _react.useState)(new _rxjs.BehaviorSubject((_initialInput$lastRel = initialInput.lastReloadRequestTime) !== null && _initialInput$lastRel !== void 0 ? _initialInput$lastRel : Date.now()));
  (0, _react.useEffect)(function updateManualReloadSubject() {
    if (input.lastReloadRequestTime === initialInput.lastReloadRequestTime || !input.lastReloadRequestTime) return;
    manualReload$.next(input.lastReloadRequestTime);
  }, [input.lastReloadRequestTime, initialInput.lastReloadRequestTime, manualReload$]);
  const resultObservable$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([reload$, manualReload$]).pipe((0, _rxjs.map)(([reload, manualReload]) => Math.max(reload, manualReload)), (0, _rxjs.distinctUntilChanged)());
  }, [manualReload$, reload$]);
  return /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: resultObservable$
  }, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViewId: input.dataViewId
  }, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    timeRange: input.timeRange
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, null, /*#__PURE__*/_react.default.createElement(ChartGridEmbeddableWrapper, {
    viewType: input.viewType,
    timeRange: input.timeRange,
    fn: input.fn,
    metricField: input.metricField,
    splitField: input.splitField,
    maxSeriesToPlot: input.maxSeriesToPlot,
    dataViewId: input.dataViewId,
    partitions: input.partitions,
    onLoading: onLoading,
    onRenderComplete: onRenderComplete,
    onError: onError,
    onChange: input.onChange,
    emptyState: input.emptyState
  })))));
};

/**
 * Grid component wrapper for embeddable.
 *
 * @param timeRange
 * @param fn
 * @param metricField
 * @param maxSeriesToPlot
 * @param splitField
 * @param partitions
 * @constructor
 */
exports.EmbeddableInputTracker = EmbeddableInputTracker;
const ChartGridEmbeddableWrapper = ({
  viewType = _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.CHARTS,
  fn,
  metricField,
  maxSeriesToPlot,
  splitField,
  partitions,
  onError,
  onLoading,
  onRenderComplete,
  onChange,
  emptyState
}) => {
  const {
    filters,
    query,
    searchBounds,
    interval
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const fieldConfig = (0, _react.useMemo)(() => {
    return {
      fn,
      metricField,
      splitField
    };
  }, [fn, metricField, splitField]);
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const combinedQuery = (0, _react.useMemo)(() => {
    var _mergedQuery$bool, _searchBounds$min, _searchBounds$max;
    const mergedQuery = (0, _search_utils.createMergedEsQuery)(query, filters, dataView, uiSettings);
    if (!Array.isArray((_mergedQuery$bool = mergedQuery.bool) === null || _mergedQuery$bool === void 0 ? void 0 : _mergedQuery$bool.filter)) {
      if (!mergedQuery.bool) {
        mergedQuery.bool = {};
      }
      mergedQuery.bool.filter = [];
    }
    mergedQuery.bool.filter.push({
      range: {
        [dataView.timeFieldName]: {
          from: (_searchBounds$min = searchBounds.min) === null || _searchBounds$min === void 0 ? void 0 : _searchBounds$min.valueOf(),
          to: (_searchBounds$max = searchBounds.max) === null || _searchBounds$max === void 0 ? void 0 : _searchBounds$max.valueOf(),
          format: 'epoch_millis'
        }
      }
    });
    if (Array.isArray(partitions) && partitions.length > 0 && fieldConfig.splitField) {
      var _mergedQuery$bool2;
      (_mergedQuery$bool2 = mergedQuery.bool) === null || _mergedQuery$bool2 === void 0 ? void 0 : _mergedQuery$bool2.filter.push({
        terms: {
          [fieldConfig.splitField]: partitions
        }
      });
    }
    return mergedQuery;
  }, [dataView, fieldConfig.splitField, filters, partitions, query, searchBounds, uiSettings]);
  const requestParams = (0, _react.useMemo)(() => {
    return {
      interval
    };
  }, [interval]);
  const {
    results,
    isLoading
  } = (0, _use_change_point_agg_request.useChangePointResults)(fieldConfig, requestParams, combinedQuery, 10000);
  (0, _react.useEffect)(() => {
    onLoading(isLoading);
  }, [onLoading, isLoading]);
  const changePoints = (0, _react.useMemo)(() => {
    let resultChangePoints = results.sort((a, b) => {
      if (defaultSort.direction === 'asc') {
        return a[defaultSort.field] - b[defaultSort.field];
      } else {
        return b[defaultSort.field] - a[defaultSort.field];
      }
    });
    if (maxSeriesToPlot) {
      resultChangePoints = resultChangePoints.slice(0, maxSeriesToPlot);
    }
    if (onChange) {
      onChange(resultChangePoints);
    }
    return resultChangePoints;
  }, [results, maxSeriesToPlot, onChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        overflow: auto;
        width: 100%;
      `
  }, changePoints.length > 0 ? viewType === _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.CHARTS ? /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    changePoints: changePoints.map(r => ({
      ...r,
      ...fieldConfig
    })),
    interval: requestParams.interval,
    onRenderComplete: onRenderComplete
  }) : viewType === _constants.CHANGE_POINT_DETECTION_VIEW_TYPE.TABLE ? /*#__PURE__*/_react.default.createElement(_change_points_table.ChangePointsTable, {
    isLoading: false,
    annotations: changePoints,
    fieldConfig: fieldConfig,
    onRenderComplete: onRenderComplete
  }) : null : !isLoading ? emptyState ? emptyState : /*#__PURE__*/_react.default.createElement(_no_change_points_warning.NoChangePointsWarning, {
    onRenderComplete: onRenderComplete
  }) : null);
};
exports.ChartGridEmbeddableWrapper = ChartGridEmbeddableWrapper;