"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableChangePointChartFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _embeddable_change_point_chart = require("./embeddable_change_point_chart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class EmbeddableChangePointChartFactory {
  constructor(type, name, getStartServices) {
    (0, _defineProperty2.default)(this, "grouping", [{
      id: 'ml',
      getDisplayName: () => _i18n.i18n.translate('xpack.aiops.navMenu.mlAppNameText', {
        defaultMessage: 'Machine Learning'
      }),
      getIconType: () => 'machineLearningApp'
    }]);
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      return true;
    });
    this.type = type;
    this.name = name;
    this.getStartServices = getStartServices;
  }
  getDisplayName() {
    return this.name;
  }
  canCreateNew() {
    return true;
  }
  async getExplicitInput() {
    const [coreStart, pluginStart] = await this.getStartServices();
    try {
      const {
        resolveEmbeddableChangePointUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handle_explicit_input')));
      return await resolveEmbeddableChangePointUserInput(coreStart, pluginStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async create(input, parent) {
    try {
      const [{
        i18n: i18nService,
        theme,
        http,
        uiSettings,
        notifications
      }, {
        lens,
        data,
        usageCollection,
        fieldFormats
      }] = await this.getStartServices();
      return new _embeddable_change_point_chart.EmbeddableChangePointChart(this.type, {
        theme,
        http,
        i18n: i18nService,
        uiSettings,
        data,
        notifications,
        lens,
        usageCollection,
        fieldFormats
      }, input, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, input, parent);
    }
  }
}
exports.EmbeddableChangePointChartFactory = EmbeddableChangePointChartFactory;