"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmbeddableChangePointChart = getEmbeddableChangePointChart;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEmbeddableChangePointChart(visType, core, plugins) {
  const {
    embeddable: embeddableStart
  } = plugins;
  const factory = embeddableStart.getEmbeddableFactory(visType);
  return props => {
    const input = {
      ...props
    };
    return /*#__PURE__*/_react.default.createElement(EmbeddableRootWrapper, {
      factory: factory,
      input: input
    });
  };
}
function EmbeddableRootWrapper({
  factory,
  input
}) {
  const [embeddable, loading, error] = (0, _public.useEmbeddableFactory)({
    factory,
    input
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null);
  }
  return /*#__PURE__*/_react.default.createElement(_public.EmbeddableRoot, {
    embeddable: embeddable,
    loading: loading,
    error: error,
    input: input
  });
}