"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResultsGroupsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlStringHash = require("@kbn/ml-string-hash");
var _aiopsComponents = require("@kbn/aiops-components");
var _mini_histogram = require("../mini_histogram");
var _get_failed_transactions_correlation_impact_label = require("./get_failed_transactions_correlation_impact_label");
var _log_rate_analysis_results_table = require("./log_rate_analysis_results_table");
var _use_copy_to_clipboard_action = require("./use_copy_to_clipboard_action");
var _use_view_in_discover_action = require("./use_view_in_discover_action");
var _use_view_in_log_pattern_analysis_action = require("./use_view_in_log_pattern_analysis_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NARROW_COLUMN_WIDTH = '120px';
const EXPAND_COLUMN_WIDTH = '40px';
const ACTIONS_COLUMN_WIDTH = '60px';
const NOT_AVAILABLE = '--';
const MAX_GROUP_BADGES = 5;
const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
const DEFAULT_SORT_FIELD = 'pValue';
const DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK = 'docCount';
const DEFAULT_SORT_DIRECTION = 'asc';
const DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK = 'desc';
const LogRateAnalysisResultsGroupsTable = ({
  significantItems,
  groupTableItems,
  loading,
  dataView,
  timeRangeMs,
  searchQuery,
  barColorOverride,
  barHighlightColorOverride,
  zeroDocsFallback = false
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK : DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK : DEFAULT_SORT_DIRECTION);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const visColors = (0, _eui.euiPaletteColorBlind)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const {
    pinnedGroup,
    selectedGroup,
    setPinnedGroup,
    setSelectedGroup
  } = (0, _aiopsComponents.useLogRateAnalysisStateContext)();
  const dataViewId = dataView.id;
  const toggleDetails = item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[item.id]) {
      delete itemIdToExpandedRowMapValues[item.id];
    } else {
      itemIdToExpandedRowMapValues[item.id] = /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsTable, {
        significantItems: item.groupItemsSortedByUniqueness.reduce((p, groupItem) => {
          const st = significantItems.find(d => d.fieldName === groupItem.fieldName && d.fieldValue === groupItem.fieldValue);
          if (st !== undefined) {
            var _groupItem$duplicate;
            p.push({
              ...st,
              unique: ((_groupItem$duplicate = groupItem.duplicate) !== null && _groupItem$duplicate !== void 0 ? _groupItem$duplicate : 0) <= 1
            });
          }
          return p;
        }, []),
        loading: loading,
        isExpandedRow: true,
        dataView: dataView,
        timeRangeMs: timeRangeMs,
        searchQuery: searchQuery,
        barColorOverride: barColorOverride,
        barHighlightColorOverride: barHighlightColorOverride
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const copyToClipBoardAction = (0, _use_copy_to_clipboard_action.useCopyToClipboardAction)();
  const viewInDiscoverAction = (0, _use_view_in_discover_action.useViewInDiscoverAction)(dataViewId);
  const viewInLogPatternAnalysisAction = (0, _use_view_in_log_pattern_analysis_action.useViewInLogPatternAnalysisAction)(dataViewId);
  const columns = [{
    align: _eui.RIGHT_ALIGNMENT,
    width: EXPAND_COLUMN_WIDTH,
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.expandRowsLabel', {
      defaultMessage: 'Expand rows'
    }))),
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": 'aiopsLogRateAnalysisResultsGroupsTableRowExpansionButton',
      onClick: () => toggleDetails(item),
      "aria-label": itemIdToExpandedRowMap[item.id] ? _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.collapseAriaLabel', {
        defaultMessage: 'Collapse'
      }) : _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.expandAriaLabel', {
        defaultMessage: 'Expand'
      }),
      iconType: itemIdToExpandedRowMap[item.id] ? 'arrowDown' : 'arrowRight'
    }),
    valign: 'top'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsGroupsTableColumnGroup',
    field: 'group',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.groupColumnTooltip', {
        defaultMessage: 'Displays up to {maxItemCount} group items sorted by uniqueness and document count. Expand row to see all field/value pairs.',
        values: {
          maxItemCount: MAX_GROUP_BADGES
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.resultsTableGroups.groupLabel",
      defaultMessage: "Group"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: (_, {
      uniqueItemsCount,
      groupItemsSortedByUniqueness
    }) => {
      const valuesBadges = [];
      for (const groupItem of groupItemsSortedByUniqueness) {
        const {
          fieldName,
          fieldValue,
          duplicate
        } = groupItem;
        if (valuesBadges.length >= MAX_GROUP_BADGES) break;
        valuesBadges.push( /*#__PURE__*/_react.default.createElement("span", {
          key: `${(0, _mlStringHash.stringHash)(`${fieldName}:${fieldValue}`)}-id`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "data-test-subj": "aiopsLogRateAnalysisResultsTableColumnGroupBadge",
          color: "hollow"
        }, /*#__PURE__*/_react.default.createElement("span", null, (duplicate !== null && duplicate !== void 0 ? duplicate : 0) <= 1 ? '* ' : '', `${fieldName}: `), /*#__PURE__*/_react.default.createElement("span", {
          style: {
            color: visColors[2]
          }
        }, `${fieldValue}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs"
        })));
      }
      if (groupItemsSortedByUniqueness.length > MAX_GROUP_BADGES) {
        valuesBadges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          key: `group-info-id`,
          "data-test-subj": "aiopsLogRateAnalysisResultsGroupsTableColumnGroupInfo",
          color: "subdued",
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.aiops.logRateAnalysis.resultsTableGroups.groupItemsInfo",
          defaultMessage: "Showing {valuesBadges} out of {count} items.",
          values: {
            count: groupItemsSortedByUniqueness.length,
            valuesBadges: valuesBadges.length
          }
        }), uniqueItemsCount > MAX_GROUP_BADGES ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.aiops.logRateAnalysis.resultsTableGroups.groupUniqueItemsInfo",
          defaultMessage: "{count, plural, one {# item} other {# items}} unique to this group.",
          values: {
            count: uniqueItemsCount
          }
        })) : null));
      }
      return valuesBadges;
    },
    sortable: false,
    textOnly: true,
    valign: 'top'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsGroupsTableColumnLogRate',
    width: NARROW_COLUMN_WIDTH,
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateColumnTooltip', {
        defaultMessage: 'A visual representation of the impact of the group on the message rate difference.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.resultsTableGroups.logRateLabel",
      defaultMessage: "Log rate"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: (_, {
      histogram,
      id
    }) => /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
      chartData: histogram,
      isLoading: loading && histogram === undefined,
      label: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.groupLabel', {
        defaultMessage: 'Group'
      }),
      barColorOverride: barColorOverride,
      barHighlightColorOverride: barHighlightColorOverride
    }),
    sortable: false,
    valign: 'top'
  }, {
    'data-test-subj': 'aiopsLogRateAnalysisResultsGroupsTableColumnDocCount',
    width: NARROW_COLUMN_WIDTH,
    field: 'docCount',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.docCountLabel', {
      defaultMessage: 'Doc count'
    }),
    sortable: true,
    valign: 'top'
  }];
  if (!zeroDocsFallback) {
    columns.push({
      'data-test-subj': 'aiopsLogRateAnalysisResultsGroupsTableColumnPValue',
      width: NARROW_COLUMN_WIDTH,
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.pValueColumnTooltip', {
          defaultMessage: 'The significance of changes in the frequency of values; lower values indicate greater change; sorting this column will automatically do a secondary sort on the doc count column.'
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTableGroups.pValueLabel",
        defaultMessage: "p-value"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop"
      }))),
      render: pValue => {
        var _pValue$toPrecision;
        return (_pValue$toPrecision = pValue === null || pValue === void 0 ? void 0 : pValue.toPrecision(3)) !== null && _pValue$toPrecision !== void 0 ? _pValue$toPrecision : NOT_AVAILABLE;
      },
      sortable: true,
      valign: 'top'
    });
    columns.push({
      'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnImpact',
      width: NARROW_COLUMN_WIDTH,
      field: 'pValue',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.impactLabelColumnTooltip', {
          defaultMessage: 'The level of impact of the group on the message rate difference'
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logRateAnalysis.resultsTableGroups.impactLabel",
        defaultMessage: "Impact"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop"
      }))),
      render: (_, {
        pValue
      }) => {
        if (!pValue) return NOT_AVAILABLE;
        const label = (0, _get_failed_transactions_correlation_impact_label.getFailedTransactionsCorrelationImpactLabel)(pValue);
        return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: label.color
        }, label.impact) : null;
      },
      sortable: true,
      valign: 'top'
    });
  }
  columns.push({
    'data-test-subj': 'aiopsLogRateAnalysisResultsTableColumnAction',
    name: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.actionsColumnName', {
      defaultMessage: 'Actions'
    }),
    actions: [...(viewInDiscoverAction ? [viewInDiscoverAction] : []), ...(viewInLogPatternAnalysisAction ? [viewInLogPatternAnalysisAction] : []), copyToClipBoardAction],
    width: ACTIONS_COLUMN_WIDTH,
    valign: 'top'
  });
  const onChange = (0, _react.useCallback)(tableSettings => {
    if (tableSettings.page) {
      const {
        index,
        size
      } = tableSettings.page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (tableSettings.sort) {
      const {
        field,
        direction
      } = tableSettings.sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const {
    pagination,
    pageOfItems,
    sorting
  } = (0, _react.useMemo)(() => {
    var _groupTableItems$leng;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_groupTableItems$leng = groupTableItems === null || groupTableItems === void 0 ? void 0 : groupTableItems.length) !== null && _groupTableItems$leng !== void 0 ? _groupTableItems$leng : 0;
    let items = groupTableItems !== null && groupTableItems !== void 0 ? groupTableItems : [];
    const sortIteratees = [item => {
      if (item && typeof item[sortField] === 'string') {
        // @ts-ignore Object is possibly null or undefined
        return item[sortField].toLowerCase();
      }
      return item[sortField];
    }];
    const sortDirections = [sortDirection];

    // Only if the table is sorted by p-value, add a secondary sort by doc count.
    if (sortField === 'pValue') {
      sortIteratees.push(item => item.docCount);
      sortDirections.push(sortDirection);
    }
    items = (0, _lodash.orderBy)(groupTableItems, sortIteratees, sortDirections);
    return {
      pageOfItems: items.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      },
      sorting: {
        sort: {
          field: sortField,
          direction: sortDirection
        }
      }
    };
  }, [pageIndex, pageSize, sortField, sortDirection, groupTableItems]);
  (0, _react.useEffect)(() => {
    // If no row is hovered or pinned or the user switched to a new page,
    // fall back to set the first row into a hovered state to make the
    // main document count chart show a comparison view by default.
    if ((selectedGroup === null || !pageOfItems.some(item => (0, _lodash.isEqual)(item, selectedGroup))) && pinnedGroup === null && pageOfItems.length > 0) {
      setSelectedGroup(pageOfItems[0]);
    }

    // If a user switched pages and a pinned row is no longer visible
    // on the current page, set the status of pinned rows back to `null`.
    if (pinnedGroup !== null && !pageOfItems.some(item => (0, _lodash.isEqual)(item, pinnedGroup))) {
      setPinnedGroup(null);
    }
  }, [selectedGroup, setSelectedGroup, setPinnedGroup, pageOfItems, pinnedGroup]);

  // When the analysis results table unmounts,
  // make sure to reset any hovered or pinned rows.
  (0, _react.useEffect)(() => () => {
    setSelectedGroup(null);
    setPinnedGroup(null);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const getRowStyle = group => {
    if (pinnedGroup && pinnedGroup.id === group.id) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedGroup && selectedGroup.id === group.id) {
      return {
        backgroundColor: euiTheme.colors.lightestShade
      };
    }
    return {
      backgroundColor: euiTheme.colors.emptyShade
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "aiopsLogRateAnalysisResultsGroupsTable",
    compressed: true,
    columns: columns,
    items: pageOfItems,
    itemId: "id",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    onChange: onChange,
    pagination: pagination.totalItemCount > pagination.pageSize ? pagination : undefined,
    loading: false,
    sorting: sorting,
    rowProps: group => {
      return {
        'data-test-subj': `aiopsLogRateAnalysisResultsGroupsTableRow row-${group.id}`,
        onClick: () => {
          if (group.id === (pinnedGroup === null || pinnedGroup === void 0 ? void 0 : pinnedGroup.id)) {
            setPinnedGroup(null);
          } else {
            setPinnedGroup(group);
          }
        },
        onMouseEnter: () => {
          if (pinnedGroup === null) {
            setSelectedGroup(group);
          }
        },
        onMouseLeave: () => {
          setSelectedGroup(null);
        },
        style: getRowStyle(group)
      };
    }
  });
};
exports.LogRateAnalysisResultsGroupsTable = LogRateAnalysisResultsGroupsTable;