"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _aiopsComponents = require("@kbn/aiops-components");
var _client = require("@kbn/ml-response-stream/client");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/aiops-common/constants");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _log_rate_analysis_results_table = require("../log_rate_analysis_results_table");
var _field_filter_popover = require("./field_filter_popover");
var _log_rate_analysis_type_callout = require("./log_rate_analysis_type_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupResultsMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResults', {
  defaultMessage: 'Smart grouping'
});
const groupResultsHelpMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsHelpMessage', {
  defaultMessage: 'Items which are unique to a group are marked by an asterisk (*).'
});
const groupResultsOffMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOff', {
  defaultMessage: 'Off'
});
const groupResultsOnMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOn', {
  defaultMessage: 'On'
});
const resultsGroupedOffId = 'aiopsLogRateAnalysisGroupingOff';
const resultsGroupedOnId = 'aiopsLogRateAnalysisGroupingOn';

/**
 * Interface for log rate analysis results data.
 */

/**
 * LogRateAnalysis props require a data view.
 */

const LogRateAnalysisResults = ({
  dataView,
  analysisType = _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE,
  earliest,
  isBrushCleared,
  latest,
  stickyHistogram,
  onReset,
  windowParameters,
  searchQuery,
  sampleProbability,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted,
  embeddingOrigin
}) => {
  var _dataView$timeFieldNa, _data$loadingState;
  const {
    analytics,
    http
  } = (0, _use_aiops_app_context.useAiopsAppContext)();

  // Store the performance metric's start time using a ref
  // to be able to track it across rerenders.
  const analysisStartTime = (0, _react.useRef)(window.performance.now());
  const {
    clearAllRowState
  } = (0, _aiopsComponents.useLogRateAnalysisStateContext)();
  const [currentAnalysisType, setCurrentAnalysisType] = (0, _react.useState)();
  const [currentAnalysisWindowParameters, setCurrentAnalysisWindowParameters] = (0, _react.useState)();
  const [groupResults, setGroupResults] = (0, _react.useState)(false);
  const [groupSkipFields, setGroupSkipFields] = (0, _react.useState)([]);
  const [uniqueFieldNames, setUniqueFieldNames] = (0, _react.useState)([]);
  const [overrides, setOverrides] = (0, _react.useState)(undefined);
  const [shouldStart, setShouldStart] = (0, _react.useState)(false);
  const [toggleIdSelected, setToggleIdSelected] = (0, _react.useState)(resultsGroupedOffId);
  const onGroupResultsToggle = optionId => {
    setToggleIdSelected(optionId);
    setGroupResults(optionId === resultsGroupedOnId);

    // When toggling the group switch, clear all row selections
    clearAllRowState();
  };
  const onFieldsFilterChange = skippedFields => {
    setGroupSkipFields(skippedFields);
    setOverrides({
      loaded: 0,
      remainingFieldCandidates: [],
      significantItems: data.significantItems.filter(d => !skippedFields.includes(d.fieldName)),
      regroupOnly: true
    });
    startHandler(true, false);
  };
  const {
    cancel,
    start,
    data,
    isRunning,
    errors: streamErrors
  } = (0, _client.useFetchStream)(http, '/internal/aiops/log_rate_analysis', '2', {
    start: earliest,
    end: latest,
    searchQuery: JSON.stringify(searchQuery),
    // TODO Handle data view without time fields.
    timeFieldName: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '',
    index: dataView.getIndexPattern(),
    grouping: true,
    flushFix: true,
    // If analysis type is `spike`, pass on window parameters as is,
    // if it's `dip`, swap baseline and deviation.
    ...(analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE ? windowParameters : {
      baselineMin: windowParameters.deviationMin,
      baselineMax: windowParameters.deviationMax,
      deviationMin: windowParameters.baselineMin,
      deviationMax: windowParameters.baselineMax
    }),
    overrides,
    sampleProbability
  }, {
    reducer: _stream_reducer.streamReducer,
    initialState: _stream_reducer.initialState
  }, {
    [_constants.AIOPS_TELEMETRY_ID.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
  });
  const {
    significantItems,
    zeroDocsFallback
  } = data;
  (0, _react.useEffect)(() => setUniqueFieldNames((0, _lodash.uniq)(significantItems.map(d => d.fieldName)).sort()), [significantItems]);
  (0, _react.useEffect)(() => {
    if (!isRunning) {
      const {
        loaded,
        remainingFieldCandidates,
        groupsMissing
      } = data;
      if (loaded < 1 && (Array.isArray(remainingFieldCandidates) && remainingFieldCandidates.length > 0 || groupsMissing)) {
        setOverrides({
          loaded,
          remainingFieldCandidates,
          significantItems: data.significantItems
        });
      } else if (loaded > 0) {
        // Reset all overrides.
        setOverrides(undefined);

        // If provided call the `onAnalysisCompleted` callback with the analysis results.
        if (onAnalysisCompleted) {
          onAnalysisCompleted({
            analysisType,
            significantItems: data.significantItems,
            significantItemsGroups: data.significantItemsGroups
          });
        }

        // Track performance metric
        if (analysisStartTime.current !== undefined) {
          const analysisDuration = window.performance.now() - analysisStartTime.current;

          // Set this to undefined so reporting the metric gets triggered only once.
          analysisStartTime.current = undefined;
          (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
            eventName: 'aiopsLogRateAnalysisCompleted',
            duration: analysisDuration
          });
        }
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isRunning]);
  const errors = (0, _react.useMemo)(() => [...streamErrors, ...data.errors], [streamErrors, data.errors]);

  // Start handler clears possibly hovered or pinned
  // significant items on analysis refresh.
  function startHandler(continueAnalysis = false, resetGroupButton = true) {
    if (!continueAnalysis) {
      setOverrides(undefined);
      setUniqueFieldNames([]);
    }

    // Reset grouping to false and clear all row selections when restarting the analysis.
    if (resetGroupButton) {
      setGroupResults(false);
      setToggleIdSelected(resultsGroupedOffId);
      clearAllRowState();
    }
    setCurrentAnalysisType(analysisType);
    setCurrentAnalysisWindowParameters(windowParameters);

    // We trigger hooks updates above so we cannot directly call `start()` here
    // because it would be run with stale arguments.
    setShouldStart(true);
  }
  (0, _react.useEffect)(() => {
    if (shouldStart) {
      start();
      setShouldStart(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [shouldStart]);
  (0, _react.useEffect)(() => {
    setCurrentAnalysisType(analysisType);
    setCurrentAnalysisWindowParameters(windowParameters);
    start();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const groupTableItems = (0, _react.useMemo)(() => (0, _log_rate_analysis_results_table.getGroupTableItems)(data.significantItemsGroups), [data.significantItemsGroups]);
  const shouldRerunAnalysis = (0, _react.useMemo)(() => currentAnalysisWindowParameters !== undefined && !(0, _lodash.isEqual)(currentAnalysisWindowParameters, windowParameters), [currentAnalysisWindowParameters, windowParameters]);
  const showLogRateAnalysisResultsTable = (data === null || data === void 0 ? void 0 : data.significantItems.length) > 0;
  const groupItemCount = groupTableItems.reduce((p, c) => {
    return p + c.groupItemsSortedByUniqueness.length;
  }, 0);
  const foundGroups = groupTableItems.length > 0 && groupItemCount > 0;
  const timeRangeMs = {
    from: earliest,
    to: latest
  };

  // Disable the grouping switch toggle only if no groups were found,
  // the toggle wasn't enabled already and no fields were selected to be skipped.
  const disabledGroupResultsSwitch = !foundGroups && !groupResults && groupSkipFields.length === 0;
  const toggleButtons = [{
    id: resultsGroupedOffId,
    label: groupResultsOffMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOff'
  }, {
    id: resultsGroupedOnId,
    label: groupResultsOnMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOn'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsLogRateAnalysisResults"
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.ProgressControls, {
    isBrushCleared: isBrushCleared,
    progress: data.loaded,
    progressMessage: (_data$loadingState = data.loadingState) !== null && _data$loadingState !== void 0 ? _data$loadingState : '',
    isRunning: isRunning,
    onRefresh: () => startHandler(false),
    onCancel: cancel,
    onReset: onReset,
    shouldRerunAnalysis: shouldRerunAnalysis
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, groupResultsMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": `aiopsLogRateAnalysisGroupSwitch${groupResults ? ' checked' : ''}`,
    buttonSize: "s",
    isDisabled: disabledGroupResultsSwitch,
    legend: "Smart grouping",
    options: toggleButtons,
    idSelected: toggleIdSelected,
    onChange: onGroupResultsToggle
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_filter_popover.FieldFilterPopover, {
    disabled: !groupResults || isRunning,
    disabledApplyButton: isRunning,
    uniqueFieldNames: uniqueFieldNames,
    onChange: onFieldsFilterChange
  }))), showLogRateAnalysisResultsTable && currentAnalysisType !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_log_rate_analysis_type_callout.LogRateAnalysisTypeCallOut, {
    analysisType: currentAnalysisType,
    zeroDocsFallback: zeroDocsFallback
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.aiops.analysis.errorCallOutTitle', {
      defaultMessage: 'The following {errorCount, plural, one {error} other {errors}} occurred running the analysis.',
      values: {
        errorCount: errors.length
      }
    }),
    color: "warning",
    iconType: "warning",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, errors.length === 1 ? /*#__PURE__*/_react.default.createElement("p", null, errors[0]) : /*#__PURE__*/_react.default.createElement("ul", null, errors.map((e, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i
  }, e))), overrides !== undefined ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsLogRateAnalysisResultsTryToContinueAnalysisButton",
    size: "s",
    onClick: () => startHandler(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.tryToContinueAnalysisButtonText",
    defaultMessage: "Try to continue analysis"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })) : null, showLogRateAnalysisResultsTable && groupResults && foundGroups && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, groupResults ? groupResultsHelpMessage : undefined)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), !isRunning && !showLogRateAnalysisResultsTable && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "aiopsNoResultsFoundEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptTitle",
      defaultMessage: "The analysis did not return any results."
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptBody",
      defaultMessage: "Try to adjust the baseline and deviation time ranges and rerun the analysis. If you still get no results, there might be no statistically significant entities contributing to this deviation in log rate."
    }))
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: stickyHistogram ? {
      height: '500px',
      overflowX: 'hidden',
      overflowY: 'auto',
      paddingTop: '20px'
    } : undefined
  }, showLogRateAnalysisResultsTable && groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsGroupsTable, {
    significantItems: data.significantItems,
    groupTableItems: groupTableItems,
    loading: isRunning,
    dataView: dataView,
    timeRangeMs: timeRangeMs,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    zeroDocsFallback: zeroDocsFallback
  }) : null, showLogRateAnalysisResultsTable && !groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsTable, {
    significantItems: data.significantItems,
    loading: isRunning,
    dataView: dataView,
    timeRangeMs: timeRangeMs,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    zeroDocsFallback: zeroDocsFallback
  }) : null));
};
exports.LogRateAnalysisResults = LogRateAnalysisResults;