"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("@kbn/aiops-common/constants");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data = require("../../hooks/use_data");
var _use_search = require("../../hooks/use_search");
var _log_rate_analysis = require("../../application/url_state/log_rate_analysis");
var _search_panel = require("../search_panel");
var _page_header = require("../page_header");
var _log_rate_analysis_content = require("./log_rate_analysis_content/log_rate_analysis_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRateAnalysisPage = ({
  stickyHistogram
}) => {
  const {
    data: dataService
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView,
    savedSearch
  } = (0, _use_data_source.useDataSource)();
  const {
    currentSelectedSignificantItem,
    currentSelectedGroup,
    setInitialAnalysisStart
  } = (0, _aiopsComponents.useLogRateAnalysisStateContext)();
  const [stateFromUrl, setUrlState] = (0, _mlUrlState.usePageUrlState)('logRateAnalysis', (0, _log_rate_analysis.getDefaultLogRateAnalysisAppState)());
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [selectedSavedSearch, setSelectedSavedSearch] = (0, _react.useState)(savedSearch);
  (0, _react.useEffect)(() => {
    if (savedSearch) {
      setSelectedSavedSearch(savedSearch);
    }
  }, [savedSearch]);
  const setSearchParams = (0, _react.useCallback)(searchParams => {
    // When the user loads a saved search and then clears or modifies the query
    // we should remove the saved search and replace it with the index pattern id
    if (selectedSavedSearch !== null) {
      setSelectedSavedSearch(null);
    }
    setUrlState({
      ...stateFromUrl,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [selectedSavedSearch, stateFromUrl, setUrlState]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch
  }, stateFromUrl);
  const {
    timefilter
  } = (0, _use_data.useData)(dataView, 'log_rate_analysis', searchQuery, setGlobalState, currentSelectedSignificantItem, currentSelectedGroup);
  (0, _react.useEffect)(
  // TODO: Consolidate this hook/function with with Data visualizer's
  function clearFiltersOnLeave() {
    return () => {
      // We want to clear all filters that have not been pinned globally
      // when navigating to other pages
      dataService.query.filterManager.getFilters().filter(f => {
        var _f$$state;
        return ((_f$$state = f.$state) === null || _f$$state === void 0 ? void 0 : _f$$state.store) === _esQuery.FilterStateStore.APP_STATE;
      }).forEach(f => dataService.query.filterManager.removeFilter(f));
    };
  }, [dataService.query.filterManager]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      if (!(0, _lodash.isEqual)({
        from: globalState.time.from,
        to: globalState.time.to
      }, timefilter.getTime())) {
        timefilter.setTime({
          from: globalState.time.from,
          to: globalState.time.to
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    // Update data query manager if input string is updated
    dataService === null || dataService === void 0 ? void 0 : dataService.query.queryString.setQuery({
      query: searchString !== null && searchString !== void 0 ? searchString : '',
      language: searchQueryLanguage
    });
  }, [dataService, searchQueryLanguage, searchString]);
  (0, _react.useEffect)(() => {
    setInitialAnalysisStart((0, _log_rate_analysis.appStateToWindowParameters)(stateFromUrl.wp));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const onWindowParametersHandler = (wp, replace = false) => {
    if (!(0, _lodash.isEqual)((0, _log_rate_analysis.windowParametersToAppState)(wp), stateFromUrl.wp)) {
      setUrlState({
        wp: (0, _log_rate_analysis.windowParametersToAppState)(wp)
      }, replace);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "aiopsLogRateAnalysisPage",
    paddingSize: "none",
    panelled: false
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_panel.SearchPanel, {
    dataView: dataView,
    searchString: searchString !== null && searchString !== void 0 ? searchString : '',
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams
  })), /*#__PURE__*/_react.default.createElement(_log_rate_analysis_content.LogRateAnalysisContent, {
    dataView: dataView,
    embeddingOrigin: _constants.AIOPS_TELEMETRY_ID.AIOPS_DEFAULT_SOURCE,
    esSearchQuery: searchQuery,
    onWindowParametersChange: onWindowParametersHandler,
    stickyHistogram: stickyHistogram
  }))));
};
exports.LogRateAnalysisPage = LogRateAnalysisPage;