"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlInMemoryTable = require("@kbn/ml-in-memory-table");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _use_eui_theme = require("../../../hooks/use_eui_theme");
var _mini_histogram = require("../../mini_histogram");
var _use_discover_links = require("../use_discover_links");
var _labels = require("./labels");
var _table_header = require("./table_header");
var _expanded_row = require("./expanded_row");
var _format_category = require("../format_category");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryTable = ({
  categories,
  eventRate,
  dataViewId,
  selectedField,
  timefilter,
  aiopsListState,
  pinnedCategory,
  setPinnedCategory,
  selectedCategory,
  setSelectedCategory,
  onAddFilter,
  onClose = () => {},
  enableRowActions = true,
  additionalFilter,
  navigateToDiscover = true,
  displayExamples = true
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const {
    openInDiscoverWithFilter
  } = (0, _use_discover_links.useDiscoverLinks)();
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _mlInMemoryTable.useTableState)(categories !== null && categories !== void 0 ? categories : [], 'key');
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const labels = (0, _react.useMemo)(() => {
    const isFlyout = onAddFilter !== undefined && onClose !== undefined;
    return (0, _labels.getLabels)(isFlyout && navigateToDiscover === false);
  }, [navigateToDiscover, onAddFilter, onClose]);
  const showSparkline = (0, _react.useMemo)(() => {
    return categories.some(category => category.sparkline !== undefined);
  }, [categories]);
  const openInDiscover = (mode, category) => {
    if (onAddFilter !== undefined && selectedField !== undefined && typeof selectedField !== 'string' && navigateToDiscover === false) {
      onAddFilter((0, _use_discover_links.createFilter)('', selectedField.name, selectedCategories, mode, category), `Patterns - ${selectedField.name}`);
      onClose();
      return;
    }
    const timefilterActiveBounds = additionalFilter !== undefined ? {
      min: (0, _moment.default)(additionalFilter.from),
      max: (0, _moment.default)(additionalFilter.to)
    } : timefilter.getActiveBounds();
    if (timefilterActiveBounds === undefined || selectedField === undefined) {
      return;
    }
    openInDiscoverWithFilter(dataViewId, typeof selectedField === 'string' ? selectedField : selectedField.name, selectedCategories, aiopsListState, timefilterActiveBounds, mode, category, additionalFilter === null || additionalFilter === void 0 ? void 0 : additionalFilter.field);
  };
  const toggleDetails = (0, _react.useCallback)(category => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[category.key]) {
      delete itemIdToExpandedRowMapValues[category.key];
    } else {
      itemIdToExpandedRowMapValues[category.key] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        category: category,
        displayExamples: displayExamples
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  }, [displayExamples, itemIdToExpandedRowMap]);
  const columns = [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "aiopsLogPatternsColumnsButton",
      onClick: () => toggleDetails(item),
      "aria-label": itemIdToExpandedRowMap[item.key] ? _i18n.i18n.translate('xpack.aiops.logCategorization.column.collapseRow', {
        defaultMessage: 'Collapse'
      }) : _i18n.i18n.translate('xpack.aiops.logCategorization.column.expandRow', {
        defaultMessage: 'Expand'
      }),
      iconType: itemIdToExpandedRowMap[item.key] ? 'arrowDown' : 'arrowRight'
    }),
    'data-test-subj': 'aiopsLogPatternsExpandRowToggle'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.count', {
      defaultMessage: 'Count'
    }),
    sortable: true,
    width: '80px'
  }, {
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.examples', {
      defaultMessage: 'Examples'
    }),
    sortable: true,
    render: item => /*#__PURE__*/_react.default.createElement(_format_category.FormattedPatternExamples, {
      category: item,
      count: 1
    })
  }, {
    name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.actions', {
      defaultMessage: 'Actions'
    }),
    sortable: false,
    width: '60px',
    actions: [{
      name: labels.singleSelect.in,
      description: labels.singleSelect.in,
      icon: 'plusInCircle',
      type: 'icon',
      'data-test-subj': 'aiopsLogPatternsActionFilterInButton',
      onClick: category => openInDiscover(_get_category_query.QUERY_MODE.INCLUDE, category)
    }, {
      name: labels.singleSelect.out,
      description: labels.singleSelect.out,
      icon: 'minusInCircle',
      type: 'icon',
      'data-test-subj': 'aiopsLogPatternsActionFilterOutButton',
      onClick: category => openInDiscover(_get_category_query.QUERY_MODE.EXCLUDE, category)
    }]
  }];
  if (displayExamples === false) {
    // on the rare occasion that examples are not available, replace the examples column with tokens
    columns.splice(2, 1, {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.aiops.logCategorization.column.tokens.tooltip', {
          defaultMessage: 'If the selected field is an alias, example documents cannot be displayed. Showing pattern tokens instead.'
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.aiops.logCategorization.column.tokens', {
        defaultMessage: 'Tokens'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop"
      }))),
      render: item => /*#__PURE__*/_react.default.createElement(_format_category.FormattedTokens, {
        category: item,
        count: 1
      })
    });
  }
  if (showSparkline === true) {
    columns.splice(2, 0, {
      field: 'sparkline',
      name: _i18n.i18n.translate('xpack.aiops.logCategorization.column.logRate', {
        defaultMessage: 'Log rate'
      }),
      sortable: false,
      width: '100px',
      render: sparkline => {
        if (sparkline === undefined) {
          return null;
        }
        const histogram = eventRate.map(({
          key: catKey,
          docCount
        }) => {
          var _sparkline$catKey;
          const term = (_sparkline$catKey = sparkline[catKey]) !== null && _sparkline$catKey !== void 0 ? _sparkline$catKey : 0;
          const newTerm = term > docCount ? docCount : term;
          const adjustedDocCount = docCount - newTerm;
          return {
            doc_count_overall: adjustedDocCount,
            doc_count_significant_item: newTerm,
            key: catKey,
            key_as_string: `${catKey}`
          };
        });
        return /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
          chartData: histogram,
          isLoading: categories === null && histogram === undefined,
          label: ''
        });
      }
    });
  }
  const selectionValue = {
    selectable: () => true,
    onSelectionChange: selectedItems => setSelectedCategories(selectedItems)
  };
  const getRowStyle = category => {
    if (pinnedCategory && pinnedCategory.key === category.key && pinnedCategory.key === category.key) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedCategory && selectedCategory.key === category.key) {
      return {
        backgroundColor: euiTheme.euiColorLightestShade
      };
    }
    return {
      backgroundColor: euiTheme.euiColorEmptyShade
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    categoriesCount: categories.length,
    selectedCategoriesCount: selectedCategories.length,
    labels: labels,
    openInDiscover: queryMode => openInDiscover(queryMode)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    items: categories,
    columns: columns,
    isSelectable: true,
    selection: selectionValue,
    itemId: "key",
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "aiopsLogPatternsTable",
    isExpandable: true,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    rowProps: category => {
      return enableRowActions ? {
        onClick: () => {
          if (category.key === (pinnedCategory === null || pinnedCategory === void 0 ? void 0 : pinnedCategory.key)) {
            setPinnedCategory(null);
          } else {
            setPinnedCategory(category);
          }
        },
        onMouseEnter: () => {
          setSelectedCategory(category);
        },
        onMouseLeave: () => {
          setSelectedCategory(null);
        },
        style: getRowStyle(category)
      } : undefined;
    }
  }));
};
exports.CategoryTable = CategoryTable;