"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processCategoryResults = processCategoryResults;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processCategoryResults(result, field, unwrap) {
  var _categories$;
  const {
    aggregations
  } = result.rawResponse;
  if (aggregations === undefined) {
    throw new Error('processCategoryResults failed, did not return aggregations.');
  }
  const {
    categories: {
      buckets
    }
  } = unwrap(aggregations);
  const categories = buckets.map(b => {
    var _b$sub_time_range$buc, _b$sub_time_range, _b$sub_time_range$buc2, _b$sub_time_range2, _b$sub_time_range2$bu, _b$sub_time_range$buc3, _b$sub_time_range3;
    const sparkline = b.sparkline === undefined ? {} : b.sparkline.buckets.reduce((acc2, cur2) => {
      acc2[cur2.key] = cur2.doc_count;
      return acc2;
    }, {});
    return {
      key: b.key,
      count: b.doc_count,
      examples: b.examples.hits.hits.map(h => (0, _lodash.get)(h._source, field)),
      sparkline,
      subTimeRangeCount: (_b$sub_time_range$buc = (_b$sub_time_range = b.sub_time_range) === null || _b$sub_time_range === void 0 ? void 0 : _b$sub_time_range.buckets[0].doc_count) !== null && _b$sub_time_range$buc !== void 0 ? _b$sub_time_range$buc : undefined,
      subFieldCount: (_b$sub_time_range$buc2 = (_b$sub_time_range2 = b.sub_time_range) === null || _b$sub_time_range2 === void 0 ? void 0 : (_b$sub_time_range2$bu = _b$sub_time_range2.buckets[0].sub_field) === null || _b$sub_time_range2$bu === void 0 ? void 0 : _b$sub_time_range2$bu.doc_count) !== null && _b$sub_time_range$buc2 !== void 0 ? _b$sub_time_range$buc2 : undefined,
      subFieldExamples: (_b$sub_time_range$buc3 = (_b$sub_time_range3 = b.sub_time_range) === null || _b$sub_time_range3 === void 0 ? void 0 : _b$sub_time_range3.buckets[0].examples.hits.hits.map(h => (0, _lodash.get)(h._source, field))) !== null && _b$sub_time_range$buc3 !== void 0 ? _b$sub_time_range$buc3 : undefined,
      regex: b.regex
    };
  });

  // check the first category for examples to determine if examples are available
  const hasExamples = (_categories$ = categories[0]) === null || _categories$ === void 0 ? void 0 : _categories$.examples.some(e => e !== undefined);
  return {
    categories,
    hasExamples
  };
}