"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistantSelectionPage = AiAssistantSelectionPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function AiAssistantSelectionPage() {
  var _capabilities$securit;
  const {
    capabilities,
    setBreadcrumbs,
    navigateToApp
  } = (0, _app_context.useAppContext)();
  const observabilityAIAssistantEnabled = capabilities.observabilityAIAssistant.show;
  const securityAIAssistantEnabled = (_capabilities$securit = capabilities.securitySolutionAssistant) === null || _capabilities$securit === void 0 ? void 0 : _capabilities$securit['ai-assistant'];
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('aiAssistantManagementSelection.breadcrumb.index', {
        defaultMessage: 'AI Assistant'
      })
    }]);
  }, [setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.h2.aIAssistantLabel', {
    defaultMessage: 'AI Assistant'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.descriptionTextLabel', {
    defaultMessage: 'AI Assistants use generative AI to help your team by explaining errors, suggesting remediation, and helping you request, analyze, and visualize your data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: /*#__PURE__*/_react.default.createElement("div", null, !observabilityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled. It can be enabled from Spaces > Features.'
      }),
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "pluginsAiAssistantSelectionPageDocumentationLink",
      external: true,
      target: "_blank",
      href: "https://www.elastic.co/guide/en/observability/current/obs-ai-assistant.html"
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.obsAssistant.documentationLinkLabel', {
      defaultMessage: 'Documentation'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "logoObservability"
    }),
    isDisabled: !observabilityAIAssistantEnabled,
    layout: "horizontal",
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.observabilityLabel', {
      defaultMessage: 'Elastic AI Assistant for Observability'
    }),
    titleSize: "xs",
    onClick: () => navigateToApp('management', {
      path: 'kibana/observabilityAiAssistantManagement'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: /*#__PURE__*/_react.default.createElement("div", null, !securityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled. It can be enabled from Spaces > Features.'
      }),
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "securityAiAssistantSelectionPageDocumentationLink",
      external: true,
      target: "_blank",
      href: "https://www.elastic.co/guide/en/security/current/security-assistant.html"
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.securityAssistant.documentationLinkLabel', {
      defaultMessage: 'Documentation'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "logoSecurity"
    }),
    isDisabled: !securityAIAssistantEnabled,
    layout: "horizontal",
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityLabel', {
      defaultMessage: 'Elastic AI Assistant for Security'
    }),
    titleSize: "xs",
    onClick: () => navigateToApp('management', {
      path: 'kibana/securityAiAssistantManagement'
    })
  }))));
}