"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _ui_setting_keys = require("../common/ui_setting_keys");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AIAssistantManagementPlugin {
  constructor() {}
  setup(core, {
    home,
    management,
    serverless
  }) {
    if (serverless) {
      return {};
    }
    if (home) {
      home.featureCatalogue.register({
        id: 'ai_assistant',
        title: _i18n.i18n.translate('aiAssistantManagementSelection.app.title', {
          defaultMessage: 'AI Assistants'
        }),
        description: _i18n.i18n.translate('aiAssistantManagementSelection.app.description', {
          defaultMessage: 'Manage your AI Assistants.'
        }),
        icon: 'sparkles',
        path: '/app/management/kibana/aiAssistantManagementSelection',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    management.sections.section.kibana.registerApp({
      id: 'aiAssistantManagementSelection',
      title: _i18n.i18n.translate('aiAssistantManagementSelection.managementSectionLabel', {
        defaultMessage: 'AI Assistants'
      }),
      order: 1,
      mount: async mountParams => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section/mount_section')));
        return mountManagementSection({
          core,
          mountParams
        });
      }
    });
    return {};
  }
  start(coreStart) {
    const preferredAIAssistantType = coreStart.uiSettings.get(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY);
    const aiAssistantType$ = new _rxjs.BehaviorSubject(preferredAIAssistantType);
    return {
      aiAssistantType$: aiAssistantType$.asObservable()
    };
  }
}
exports.AIAssistantManagementPlugin = AIAssistantManagementPlugin;