"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */
const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: {
    // A task that was created < 8.10 will go through this "up" migration
    // to ensure it matches the v1 schema.
    up: state => ({
      has_errors: state.has_errors || false,
      error_messages: state.error_messages || undefined,
      runs: state.runs || 0,
      count_total: state.count_total || 0,
      count_by_type: state.count_by_type || {},
      count_active_total: state.count_active_total || 0,
      count_active_by_type: state.count_active_by_type || {},
      count_active_alert_history_connectors: state.count_active_alert_history_connectors || 0,
      count_active_email_connectors_by_service_type: state.count_active_email_connectors_by_service_type || {},
      count_actions_namespaces: state.count_actions_namespaces || 0,
      count_actions_executions_per_day: state.count_actions_executions_per_day || 0,
      count_actions_executions_by_type_per_day: state.count_actions_executions_by_type_per_day || {},
      count_actions_executions_failed_per_day: state.count_actions_executions_failed_per_day || 0,
      count_actions_executions_failed_by_type_per_day: state.count_actions_executions_failed_by_type_per_day || {},
      avg_execution_time_per_day: state.avg_execution_time_per_day || 0,
      avg_execution_time_by_type_per_day: state.avg_execution_time_by_type_per_day || {},
      count_connector_types_by_action_run_outcome_per_day: state.count_connector_types_by_action_run_outcome_per_day || {}
    }),
    schema: _configSchema.schema.object({
      has_errors: _configSchema.schema.boolean(),
      error_messages: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
      runs: _configSchema.schema.number(),
      count_total: _configSchema.schema.number(),
      count_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_gen_ai_provider_types: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_active_total: _configSchema.schema.number(),
      count_active_by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_active_alert_history_connectors: _configSchema.schema.number(),
      count_active_email_connectors_by_service_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_actions_namespaces: _configSchema.schema.number(),
      count_actions_executions_per_day: _configSchema.schema.number(),
      count_actions_executions_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_actions_executions_failed_per_day: _configSchema.schema.number(),
      count_actions_executions_failed_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      avg_execution_time_per_day: _configSchema.schema.number(),
      avg_execution_time_by_type_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
      count_connector_types_by_action_run_outcome_per_day: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()))
    })
  }
};
const latestTaskStateSchema = stateSchemaByVersion[1].schema;
const emptyState = exports.emptyState = {
  has_errors: false,
  error_messages: undefined,
  runs: 0,
  count_total: 0,
  count_by_type: {},
  count_gen_ai_provider_types: {},
  count_active_total: 0,
  count_active_by_type: {},
  count_active_alert_history_connectors: 0,
  count_active_email_connectors_by_service_type: {},
  count_actions_namespaces: 0,
  count_actions_executions_per_day: 0,
  count_actions_executions_by_type_per_day: {},
  count_actions_executions_failed_per_day: 0,
  count_actions_executions_failed_by_type_per_day: {},
  avg_execution_time_per_day: 0,
  avg_execution_time_by_type_per_day: {},
  count_connector_types_by_action_run_outcome_per_day: {}
};