"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiFontSize = exports.euiTextTruncate = exports.euiTextBreakWord = exports.euiNumberFormat = exports.euiFontSize = void 0;
var _typography = require("../functions/typography");
var _theme = require("../../services/theme");
var _typography2 = require("../variables/typography");
var _functions = require("../functions");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
/**
 * Returns font-size and line-height
 */
var euiFontSize = function euiFontSize(_ref, scale, options) {
  var euiTheme = _ref.euiTheme;
  return {
    fontSize: (0, _typography.euiFontSizeFromScale)(scale, euiTheme, options),
    lineHeight: (0, _typography.euiLineHeightFromBaseline)(scale, euiTheme, options)
  };
};
exports.euiFontSize = euiFontSize;
var useEuiFontSize = function useEuiFontSize(scale, options) {
  var euiTheme = (0, _theme.useEuiTheme)();
  var memoizedFontSizes = (0, _theme.useEuiMemoizedStyles)(euiFontSizes);
  return !options ? memoizedFontSizes[scale] : euiFontSize(euiTheme, scale, options);
};
// Memomize a basic set of font sizes. We unfortunately can't
// memoize all possible options, there's too many permutations
exports.useEuiFontSize = useEuiFontSize;
var euiFontSizes = function euiFontSizes(euiThemeContext) {
  return _typography2.EuiThemeFontScales.reduce(function (map, scale) {
    return _objectSpread(_objectSpread({}, map), {}, _defineProperty({}, scale, euiFontSize(euiThemeContext, scale)));
  }, {});
};

/**
 * Force text to wrap on natural word breaks (e.g. spaces & hyphens)
 * https://css-tricks.com/snippets/css/prevent-long-urls-from-breaking-out-of-container/
 */
var euiTextBreakWord = function euiTextBreakWord() {
  return "\n  overflow-wrap: break-word !important; // makes sure the long string will wrap and not bust out of the container\n  word-break: break-word;\n";
};

/**
 * Prevent text from wrapping onto multiple lines, and truncate with an ellipsis.
 */
exports.euiTextBreakWord = euiTextBreakWord;
var euiTextTruncate = function euiTextTruncate() {
  var maxWidth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '100%';
  return "\n  ".concat((0, _functions.logicalCSS)('max-width', maxWidth) // Ensure that the node has a maximum width after which truncation can occur
  , "\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n");
};

/**
 * Fixed-width numbers for tabular data
 */
exports.euiTextTruncate = euiTextTruncate;
var euiNumberFormat = function euiNumberFormat(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return "\n  font-feature-settings: ".concat(euiTheme.font.featureSettings, ", 'tnum' 1;\n");
};
exports.euiNumberFormat = euiNumberFormat;