"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiPaddingSize = exports.useEuiPaddingCSS = exports.euiPaddingSize = exports.PADDING_SIZES = void 0;
var _react = require("@emotion/react");
var _theme = require("../../services/theme");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
exports.PADDING_SIZES = PADDING_SIZES;
/**
 * Get a single padding size
 */

var euiPaddingSize = function euiPaddingSize(_ref, size) {
  var euiTheme = _ref.euiTheme;
  switch (size) {
    case 'none':
      return null;
    case 'm':
      return euiTheme.size.base;
    default:
      return euiTheme.size[size];
  }
};

/**
 * @returns An object map of padding size keys to padding values,
 * e.g. { s: '8px', m: '16px', ... }
 */
exports.euiPaddingSize = euiPaddingSize;
var _getEuiPaddingSize = function _getEuiPaddingSize(euiThemeContext) {
  return PADDING_SIZES.reduce(function (stylesAcc, size) {
    return _objectSpread(_objectSpread({}, stylesAcc), {}, _defineProperty({}, size, size === 'none' ? null : euiPaddingSize(euiThemeContext, size)));
  }, {});
};
var useEuiPaddingSize = function useEuiPaddingSize(size) {
  var sizes = (0, _theme.useEuiMemoizedStyles)(_getEuiPaddingSize);
  return sizes[size];
};

/**
 * @returns An object map of all padding sizes for all padding sides properties
 * e.g., {
 *   padding: { s: css`padding-size: 8px`, ... }
 *   left: { s: css`padding-inline-start: 8px`, ... }
 * }
 */
exports.useEuiPaddingSize = useEuiPaddingSize;
var _euiPaddingSidesAndSizes = function _euiPaddingSidesAndSizes(euiThemeContext) {
  var sizesMap = _getEuiPaddingSize(euiThemeContext);
  // The `_` prefix stops Emotion from applying the function name as a label
  var _generateSizeStyles = function _generateSizeStyles(cssProperty) {
    return Object.fromEntries(Object.entries(sizesMap).map(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        sizeKey = _ref3[0],
        sizeValue = _ref3[1];
      return [sizeKey, sizeValue === null ? null : /*#__PURE__*/(0, _react.css)(cssProperty, ":", sizeValue, ";label:", sizeKey, ";")];
    }));
  };
  var sidesMap = {
    padding: _generateSizeStyles('padding'),
    vertical: _generateSizeStyles('padding-block'),
    top: _generateSizeStyles('padding-block-start'),
    bottom: _generateSizeStyles('padding-block-end'),
    horizontal: _generateSizeStyles('padding-inline'),
    left: _generateSizeStyles('padding-inline-start'),
    right: _generateSizeStyles('padding-inline-end')
  };
  return sidesMap;
};
var useEuiPaddingCSS = function useEuiPaddingCSS(side) {
  var memoizedSideMap = (0, _theme.useEuiMemoizedStyles)(_euiPaddingSidesAndSizes);
  return memoizedSideMap[side || 'padding'];
};
exports.useEuiPaddingCSS = useEuiPaddingCSS;