"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiBorderColorCSS = exports.useEuiBackgroundColorCSS = exports.useEuiBackgroundColor = exports.euiBorderColor = exports.euiBackgroundColor = exports.BACKGROUND_COLORS = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var BACKGROUND_COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
exports.BACKGROUND_COLORS = BACKGROUND_COLORS;
/**
 * @returns A single background color with optional alpha transparency
 */
var euiBackgroundColor = function euiBackgroundColor(_ref, color) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
    method = _ref2.method;
  if (color === 'transparent') return 'transparent';
  if (method === 'transparent') {
    if (color === 'plain') {
      return (0, _services.transparentize)(euiTheme.colors.ghost, 0.2);
    } else if (color === 'subdued') {
      return colorMode === 'DARK' ? (0, _services.transparentize)(euiTheme.colors.lightShade, 0.4) : (0, _services.transparentize)(euiTheme.colors.lightShade, 0.2);
    } else {
      return (0, _services.transparentize)(euiTheme.colors[color], 0.1);
    }
  } else {
    var _tintOrShade = function _tintOrShade(color) {
      return colorMode === 'DARK' ? (0, _services.shade)(color, 0.8) : (0, _services.tint)(color, 0.9);
    };
    switch (color) {
      case 'plain':
        return euiTheme.colors.emptyShade;
      case 'subdued':
        return euiTheme.colors.body;
      default:
        return _tintOrShade(euiTheme.colors[color]);
    }
  }
};

/**
 * @returns An object map of color keys to color values, categorized by
 * opaque (default) vs transparency (hover/focus states) methods.
 * e.g. {
 *  opaque: { danger: '#000', success: '#fff', ... },
 *  transparent: { danger: 'rgba(0,0,0,0.1)', success: 'rgba(255,255,255,0.1)', ... },
 * }
 */
exports.euiBackgroundColor = euiBackgroundColor;
var _euiBackgroundColorMap = function _euiBackgroundColorMap(euiThemeContext) {
  return {
    opaque: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color)));
    }, {}),
    transparent: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color, {
        method: 'transparent'
      })));
    }, {})
  };
};
var useEuiBackgroundColor = function useEuiBackgroundColor(color) {
  var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    method = _ref3.method;
  var backgroundColorMap = (0, _services.useEuiMemoizedStyles)(_euiBackgroundColorMap);
  return backgroundColorMap[method || 'opaque'][color];
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
exports.useEuiBackgroundColor = useEuiBackgroundColor;
var _euiBackgroundColors = function _euiBackgroundColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("background-color:", euiBackgroundColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
var useEuiBackgroundColorCSS = function useEuiBackgroundColorCSS() {
  return (0, _services.useEuiMemoizedStyles)(_euiBackgroundColors);
};

/**
 * Border colors
 */
exports.useEuiBackgroundColorCSS = useEuiBackgroundColorCSS;
var euiBorderColor = function euiBorderColor(_ref4, color) {
  var euiTheme = _ref4.euiTheme,
    colorMode = _ref4.colorMode;
  switch (color) {
    case 'transparent':
    case 'plain':
    case 'subdued':
      return euiTheme.border.color;
    case 'warning':
      return (0, _services.tintOrShade)(euiTheme.colors.warning, 0.4, colorMode);
    default:
      return (0, _services.tintOrShade)(euiTheme.colors[color], 0.6, colorMode);
  }
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
exports.euiBorderColor = euiBorderColor;
var _euiBorderColors = function _euiBorderColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("border-color:", euiBorderColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
var useEuiBorderColorCSS = function useEuiBorderColorCSS() {
  return (0, _services.useEuiMemoizedStyles)(_euiBorderColors);
};
exports.useEuiBorderColorCSS = useEuiBorderColorCSS;