"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeViewItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _tree_view_item = require("./tree_view_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "label", "className", "children", "display", "icon", "hasArrow", "isActive", "isExpanded", "buttonRef", "wrapperProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiTreeViewItem = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var id = _ref.id,
    label = _ref.label,
    className = _ref.className,
    children = _ref.children,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'default' : _ref$display,
    icon = _ref.icon,
    hasArrow = _ref.hasArrow,
    isActive = _ref.isActive,
    isExpanded = _ref.isExpanded,
    buttonRef = _ref.buttonRef,
    wrapperProps = _ref.wrapperProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _tree_view_item.euiTreeViewItemStyles)(euiTheme);
  var wrapperClasses = (0, _classnames.default)('euiTreeView__node', {
    'euiTreeView__node--expanded': isExpanded
  }, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className);
  var wrapperStyles = [styles.li.euiTreeView__node, styles.li[display], isExpanded && styles.li.expanded];
  var buttonClasses = (0, _classnames.default)('euiTreeView__nodeInner', className, {
    'euiTreeView__node--active': isActive
  });
  var buttonStyles = [styles.button.euiTreeView__nodeInner, styles.button[display]];
  var iconStyles = [styles.icon.euiTreeView__iconWrapper, styles.icon[display]];
  return (0, _react2.jsx)("li", _extends({}, wrapperProps, {
    css: wrapperStyles,
    className: wrapperClasses
  }), (0, _react2.jsx)("button", _extends({
    id: id,
    css: buttonStyles,
    className: buttonClasses,
    "aria-expanded": isExpanded,
    ref: buttonRef
  }, rest), hasArrow && (!!children ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTreeView__expansionArrow",
    size: display === 'compressed' ? 's' : 'm',
    type: isExpanded ? 'arrowDown' : 'arrowRight'
  }) : (0, _react2.jsx)("span", {
    css: iconStyles,
    className: "euiTreeView__arrowPlaceholder"
  })), icon && (0, _react2.jsx)("span", {
    css: iconStyles,
    className: "euiTreeView__iconWrapper"
  }, icon), (0, _react2.jsx)("span", {
    className: "euiTreeView__nodeLabel eui-textTruncate"
  }, label)), children);
});
exports.EuiTreeViewItem = EuiTreeViewItem;
EuiTreeViewItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Required for `aria-controls` accessibility
       */
  id: _propTypes.default.string.isRequired,
  /**
       * The main button content
       */
  label: _propTypes.default.node.isRequired,
  /**
       * Used to render nested `EuiTreeView`s
       */
  children: _propTypes.default.node,
  /**
       * Optional icon to render. Pass, e.g., `<EuiIcon />` or `<EuiToken />`
       */
  icon: _propTypes.default.node,
  /**
       * Renders an arrow if `children` exists. Otherwise renders a blank icon
       */
  hasArrow: _propTypes.default.bool,
  /**
       * Adds a targetable modifier class
       */
  isActive: _propTypes.default.bool,
  /**
       * Sets the `aria-expanded` attribute
       */
  isExpanded: _propTypes.default.bool,
  /**
       * Determines default or compressed display
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  buttonRef: _propTypes.default.any,
  /**
       * Optional extra props to pass to the wrapping `<li>`
       */
  wrapperProps: _propTypes.default.any
};
EuiTreeViewItem.displayName = 'EuiTreeViewItem';