"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeViewClass = exports.EuiTreeView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _tree_view_item = require("./tree_view_item");
var _tree_view = require("./tree_view.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows", "theme"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var EuiTreeViewContext = /*#__PURE__*/(0, _react.createContext)('');
function getTreeId(propId) {
  var contextId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var idGenerator = arguments.length > 2 ? arguments[2] : undefined;
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
var EuiTreeViewClass = /*#__PURE__*/function (_Component) {
  _inherits(EuiTreeViewClass, _Component);
  var _super = _createSuper(EuiTreeViewClass);
  function EuiTreeViewClass(props,
  // Without the optional ? typing, TS will throw errors on JSX component errors
  // @see https://github.com/facebook/react/issues/13944#issuecomment-1183693239
  context) {
    var _this;
    _classCallCheck(this, EuiTreeViewClass);
    // TODO: context in constructor has been deprecated.
    // We should likely convert this to a function component
    _this = _super.call(this, props, context);
    _defineProperty(_assertThisInitialized(_this), "treeIdGenerator", (0, _services.htmlIdGenerator)('euiTreeView'));
    _defineProperty(_assertThisInitialized(_this), "isNested", void 0);
    _defineProperty(_assertThisInitialized(_this), "buttonRef", []);
    _defineProperty(_assertThisInitialized(_this), "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat(_toConsumableArray(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    _defineProperty(_assertThisInitialized(_this), "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event, node) {
      switch (event.key) {
        case _services.keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case _services.keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onChildrenKeydown", function (event, index) {
      if (event.key === _services.keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    _this.isNested = !!_this.context;
    _this.state = {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    };
    return _this;
  }
  _createClass(EuiTreeViewClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var styles = (0, _tree_view.euiTreeViewStyles)(theme);
      var cssStyles = [styles.euiTreeView, styles[display]];

      // Computed classNames
      var classes = (0, _classnames.default)('euiTreeView', className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return (0, _react2.jsx)(EuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, !this.isNested && (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), (0, _react2.jsx)("ul", _extends({
        css: cssStyles,
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined,
        role: "list" // VoiceOver doesn't parse lists with `list-style: none` as the correct role - @see https://www.scottohara.me/blog/2019/01/12/lists-and-safari.html
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        var isNodeExpanded = node.children ? _this2.isNodeOpen(node) : undefined; // Determines the `aria-expanded` attribute

        var icon = node.icon;
        if (node.iconWhenExpanded && isNodeExpanded) {
          icon = node.iconWhenExpanded;
        } else if (!icon && node.useEmptyIcon) {
          icon = (0, _react2.jsx)(_react.default.Fragment, null); // Renders a placeholder
        }

        return (0, _react2.jsx)(_tree_view_item.EuiTreeViewItem, {
          key: buttonId + index,
          id: buttonId,
          className: node.className,
          buttonRef: function buttonRef(ref) {
            return _this2.setButtonRef(ref, index);
          },
          "aria-controls": node.children ? wrappingId : undefined,
          label: node.label,
          icon: icon,
          hasArrow: showExpansionArrows,
          isExpanded: isNodeExpanded,
          isActive: _this2.state.activeItem === node.id,
          display: display,
          "data-test-subj": "euiTreeViewButton-".concat(_this2.state.treeID),
          onKeyDown: function onKeyDown(event) {
            return _this2.onKeyDown(event, node);
          },
          onClick: function onClick() {
            return _this2.handleNodeClick(node);
          }
        }, node.children && (0, _react2.jsx)("div", {
          id: wrappingId,
          onKeyDown: function onKeyDown(event) {
            return _this2.onChildrenKeydown(event, index);
          }
        }, isNodeExpanded && (0, _react2.jsx)(EuiTreeView, {
          items: node.children,
          display: display,
          showExpansionArrows: showExpansionArrows,
          expandByDefault: _this2.state.expandChildNodes
        })));
      })));
    }
  }]);
  return EuiTreeViewClass;
}(_react.Component);
exports.EuiTreeViewClass = EuiTreeViewClass;
_defineProperty(EuiTreeViewClass, "contextType", EuiTreeViewContext);
EuiTreeViewClass.propTypes = {
  className: _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * An array of EuiTreeViewNodes
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /** An array of EuiTreeViewNodes to render as children
       */
    children: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /** The readable label for the item
       */
    label: _propTypes.default.node.isRequired,
    /** A unique ID
       */
    id: _propTypes.default.string.isRequired,
    /** An icon to use on the left of the label
       */
    icon: _propTypes.default.element,
    /** Display a different icon when the item is expanded.
      For instance, an open folder or a down arrow
      */
    iconWhenExpanded: _propTypes.default.element,
    /** Use an empty icon to keep items without an icon
      lined up with their siblings
      */
    useEmptyIcon: _propTypes.default.bool,
    /** Whether or not the item is expanded.
       */
    isExpanded: _propTypes.default.bool,
    /** Optional class to throw on the node
       */
    className: _propTypes.default.string,
    /** Function to call when the item is clicked.
       The open state of the item will always be toggled.
       */
    callback: _propTypes.default.func
  }).isRequired).isRequired,
  /**
       * Optionally use a variation with smaller text and icon sizes
       * @default default
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  /**
       * Set all items to open on initial load
       */
  expandByDefault: _propTypes.default.bool,
  /**
       * Display expansion arrows next to all items
       * that contain children
       */
  showExpansionArrows: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "aria-labelledby": _propTypes.default.string
};
var EuiTreeView = Object.assign((0, _services.withEuiTheme)(EuiTreeViewClass), {
  Item: _tree_view_item.EuiTreeViewItem
});
exports.EuiTreeView = EuiTreeView;