"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTourFooterStyles = exports._tourFooterBgColor = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var _tourFooterBgColor = function _tourFooterBgColor(_ref) {
  var colorMode = _ref.colorMode,
    euiTheme = _ref.euiTheme;
  return colorMode === 'DARK' ? (0, _services.shade)(euiTheme.colors.lightestShade, 0.45) : (0, _services.tint)(euiTheme.colors.lightestShade, 0.5);
};
exports._tourFooterBgColor = _tourFooterBgColor;
var euiTourFooterStyles = function euiTourFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiTourFooter: /*#__PURE__*/(0, _react.css)("background-color:", _tourFooterBgColor(euiThemeContext), ";", (0, _global_styling.logicalCSS)('border-bottom-left-radius', euiTheme.border.radius.medium), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', euiTheme.border.radius.medium), ";;label:euiTourFooter;")
  };
};
exports.euiTourFooterStyles = euiTourFooterStyles;