"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _button = require("../button");
var _flex = require("../flex");
var _tour_step_indicator = require("./tour_step_indicator");
var _tour_footer = require("./_tour_footer.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; } /*
                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                     */
var EuiTourFooter = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var footerAction = _ref.footerAction,
    step = _ref.step,
    stepsTotal = _ref.stepsTotal,
    onFinish = _ref.onFinish;
  var euiTheme = (0, _services.useEuiTheme)();
  var footerStyles = (0, _tour_footer.euiTourFooterStyles)(euiTheme);
  var customFooterAction = (0, _react.useMemo)(function () {
    if (!footerAction) return null;
    return Array.isArray(footerAction) ? (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      wrap: true
    }, footerAction.map(function (action, index) {
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        key: index,
        grow: false
      }, action);
    })) : (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, footerAction);
  }, [footerAction]);
  var indicators = (0, _react.useMemo)(function () {
    if (stepsTotal <= 1) return null;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)("ul", {
      className: "euiTourFooter__stepList"
    }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
      var status = 'complete';
      if (step === i + 1) {
        status = 'active';
      } else if (step <= i) {
        status = 'incomplete';
      }
      return (0, _react2.jsx)(_tour_step_indicator.EuiTourStepIndicator, {
        key: i,
        number: i + 1,
        status: status
      });
    })));
  }, [step, stepsTotal]);
  return (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    css: footerStyles.euiTourFooter,
    className: "euiTourFooter"
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd',
    alignItems: "center"
  }, indicators, footerAction ? customFooterAction : (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiTourFooter.endTour', 'euiTourFooter.skipTour', 'euiTourFooter.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    return (0, _react2.jsx)(_button.EuiButtonEmpty, {
      onClick: onFinish,
      color: "text",
      flush: "right",
      size: "xs"
    }, stepsTotal > 1 ? stepsTotal === step ? endTour : skipTour : closeTour);
  }))));
});
exports.EuiTourFooter = EuiTourFooter;
EuiTourFooter.displayName = '_EuiTourFooter';