"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolTipManager = void 0;
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Manager utility that ensures only one tooltip is visible at a time
 *
 * UX rationale (primarily for mouse-only users):
 * @see https://github.com/elastic/kibana/issues/144482
 * @see https://github.com/elastic/eui/issues/5883
 */
var ToolTipManager = /*#__PURE__*/_createClass(function ToolTipManager() {
  var _this = this;
  _classCallCheck(this, ToolTipManager);
  // We use a set instead of a single var just in case
  // multiple tooltips are registered via async shenanigans
  _defineProperty(this, "toolTipsToHide", new Set());
  _defineProperty(this, "registerTooltip", function (hideCallback) {
    _this.toolTipsToHide.forEach(function (hide) {
      return hide();
    });
    _this.toolTipsToHide.clear();
    _this.toolTipsToHide.add(hideCallback);
  });
  _defineProperty(this, "deregisterToolTip", function (hideCallback) {
    _this.toolTipsToHide.delete(hideCallback);
  });
});
var toolTipManager = new ToolTipManager();
exports.toolTipManager = toolTipManager;