"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSideNavItemStyles = exports.euiSideNavItemButtonStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _title = require("../title/title.styles");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var euiSideNavItemStyles = function euiSideNavItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var emphasizedBackgroundColor = (0, _services.transparentize)(euiTheme.colors.lightShade, 0.3);
  return {
    euiSideNavItem: /*#__PURE__*/(0, _react.css)(";label:euiSideNavItem;"),
    emphasized: /*#__PURE__*/(0, _react.css)("background-color:", emphasizedBackgroundColor, ";color:", euiTheme.colors.title, ";box-shadow:100px 0 0 0 ", emphasizedBackgroundColor, ",-100px 0 0 0 ", emphasizedBackgroundColor, ";& &{background-color:transparent;box-shadow:none;};label:emphasized;"),
    // Layout
    root: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.s), " &+&{", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('padding-top', euiTheme.size.s), ";};label:root;"),
    trunk: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.title, ";;label:trunk;"),
    branch: /*#__PURE__*/(0, _react.css)("position:relative;color:", euiTheme.colors.subduedText, ";&::after{position:absolute;content:'';", (0, _global_styling.logicalCSS)('vertical', 0), " ", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('width', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";}&:last-of-type::after{", (0, _global_styling.logicalCSS)('height', euiTheme.size.m), ";};label:branch;"),
    items: {
      euiSideNavItem__items: /*#__PURE__*/(0, _react.css)(";label:euiSideNavItem__items;"),
      rootWithIcon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.l), ";;label:rootWithIcon;"),
      trunk: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";;label:trunk;"),
      branch: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.base), ";;label:branch;")
    }
  };
};
exports.euiSideNavItemStyles = euiSideNavItemStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1nca8qt-euiSideNavItemButton__label",
  styles: "flex-grow:1;label:euiSideNavItemButton__label;"
} : {
  name: "1nca8qt-euiSideNavItemButton__label",
  styles: "flex-grow:1;label:euiSideNavItemButton__label;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSideNavItemButtonStyles = function euiSideNavItemButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var lineHeightOverride = (0, _global_styling.euiFontSize)(euiThemeContext, 'm').lineHeight;

  // Create padding around focus area without indenting the item itself.
  var paddingMarginOffset = "\n    padding-inline: ".concat(euiTheme.size.s, ";\n    ").concat((0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.size.s)), "\n    ").concat((0, _global_styling.logicalCSS)('width', "calc(100% + ".concat((0, _global_styling.mathWithUnits)(euiTheme.size.s, function (x) {
    return x * 2;
  }), ")")), ";\n  ");
  return {
    euiSideNavItemButton: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), "padding-block:", euiTheme.size.xxs, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";line-height:", lineHeightOverride, ";text-align:start;color:inherit;&:is(a, button):not(:disabled){&:hover{cursor:pointer;}&:hover,&:focus{.euiSideNavItemButton__label{text-decoration:underline;}}}&:disabled{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";};label:euiSideNavItemButton;"),
    selected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";font-weight:", euiTheme.font.weight.bold, ";.euiSideNavItemButton__label{text-decoration:underline;};label:selected;"),
    emphasized: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.bold, ";;label:emphasized;"),
    // Layout
    root: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.xs), " padding-block:0;", paddingMarginOffset, ";;label:root;"),
    trunk: /*#__PURE__*/(0, _react.css)(paddingMarginOffset, ";;label:trunk;"),
    branch: /*#__PURE__*/(0, _react.css)("position:relative;padding-inline:", euiTheme.size.s, ";&::after{position:absolute;content:'';", (0, _global_styling.logicalCSS)('top', euiTheme.size.m), " ", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('width', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";};label:branch;"),
    // Child elements
    euiSideNavItemButton__content: /*#__PURE__*/(0, _react.css)("display:flex;align-items:center;gap:", euiTheme.size.s, ";;label:euiSideNavItemButton__content;"),
    label: {
      euiSideNavItemButton__label: _ref,
      root: _objectSpread(_objectSpread({}, (0, _title.euiTitle)(euiThemeContext, 'xxs')), {}, {
        lineHeight: lineHeightOverride,
        color: 'inherit'
      })
    }
  };
};
exports.euiSideNavItemButtonStyles = euiSideNavItemButtonStyles;