"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.POSITIONS = exports.EuiProgress = exports.COLORS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _inner_text = require("../inner_text");
var _predicate = require("../../services/predicate");
var _services = require("../../services");
var _progress = require("./progress.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SIZES = ['xs', 's', 'm', 'l'];
exports.SIZES = SIZES;
var COLORS = ['primary', 'success', 'warning', 'danger', 'subdued', 'accent', 'vis0', 'vis1', 'vis2', 'vis3', 'vis4', 'vis5', 'vis6', 'vis7', 'vis8', 'vis9'];
exports.COLORS = COLORS;
var POSITIONS = ['fixed', 'absolute', 'static'];
exports.POSITIONS = POSITIONS;
var EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    max = _ref.max,
    _ref$valueText = _ref.valueText,
    valueText = _ref$valueText === void 0 ? false : _ref$valueText,
    label = _ref.label,
    value = _ref.value,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var determinate = !(0, _predicate.isNil)(max);
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyles = !isNamedColor ? {
    color: color
  } : {};
  var customTextColorStyles = !isNamedColor ? {
    color: (0, _services.makeHighContrastColor)(color)(euiTheme.euiTheme)
  } : {};
  var styles = (0, _progress.euiProgressStyles)(euiTheme, determinate);
  var cssStyles = [styles.euiProgress, determinate && styles.native, !determinate && styles.indeterminate, styles[size], styles[position], isNamedColor ? styles[color] : styles.customColor];
  var dataStyles = (0, _progress.euiProgressDataStyles)(euiTheme);
  var dataCssStyles = [dataStyles.euiProgress__data, size === 'l' && dataStyles[size]];
  var labelCssStyles = [_progress.euiProgressLabelStyles.euiProgress__label, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  var valueTextStyles = (0, _progress.euiProgressValueTextStyles)(euiTheme);
  var valueTextCssStyles = [valueTextStyles.euiProgress__valueText, isNamedColor ? valueTextStyles[color] : styles.customColor];
  var classes = (0, _classnames.default)('euiProgress', className);
  var labelClasses = (0, _classnames.default)('euiProgress__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var valueRender;
  if (valueText === true) {
    // valueText is true
    valueRender = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  }

  // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/

  if (determinate) {
    return (0, _react2.jsx)(_react.Fragment, null, label || valueText ? (0, _react2.jsx)("div", {
      css: dataCssStyles,
      className: "euiProgress__data"
    }, label && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", _extends({
        title: innerText,
        ref: ref
      }, labelProps, {
        className: labelClasses,
        css: labelCssStyles
      }), label);
    }), valueRender && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", {
        title: innerText,
        ref: ref,
        style: customTextColorStyles,
        css: valueTextCssStyles,
        className: "euiProgress__valueText"
      }, valueRender);
    })) : undefined, (0, _react2.jsx)("progress", _extends({
      css: cssStyles,
      className: classes,
      style: customColorStyles,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return (0, _react2.jsx)("div", _extends({
      css: cssStyles,
      style: customColorStyles,
      className: classes
    }, rest));
  }
};
exports.EuiProgress = EuiProgress;
EuiProgress.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any,
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  position: _propTypes.default.any,
  max: _propTypes.default.number,
  /*
       * If true, will render the percentage, otherwise pass a custom node
       */
  valueText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  label: _propTypes.default.node,
  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};