"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiOverlayMask = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _common = require("../common");
var _services = require("../../services");
var _portal = require("../portal");
var _overlay_mask = require("./overlay_mask.styles");
var _overlay_mask_body = require("./overlay_mask_body.styles");
var _excluded = ["className", "children", "headerZindexLocation", "maskRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiOverlayMask = function EuiOverlayMask(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headerZindexLoca = _ref.headerZindexLocation,
    headerZindexLocation = _ref$headerZindexLoca === void 0 ? 'above' : _ref$headerZindexLoca,
    maskRef = _ref.maskRef,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    overlayMaskNode = _useState2[0],
    setOverlayMaskNode = _useState2[1];
  var combinedMaskRef = (0, _services.useCombinedRefs)([setOverlayMaskNode, maskRef]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _overlay_mask.euiOverlayMaskStyles)(euiTheme);
  var cssStyles = (0, _css.cx)([styles.euiOverlayMask, styles["".concat(headerZindexLocation, "Header")]]);
  (0, _react.useEffect)(function () {
    if (!overlayMaskNode) return;
    (0, _common.keysOf)(rest).forEach(function (key) {
      if (typeof rest[key] !== 'string') {
        throw new Error("Unhandled property type. EuiOverlayMask property ".concat(key, " is not a string."));
      }
      if (overlayMaskNode) {
        overlayMaskNode.setAttribute(key, rest[key]);
      }
    });
  }, [overlayMaskNode]); // eslint-disable-line react-hooks/exhaustive-deps

  // Note: Use `classList.add/remove` instead of setting the entire `className`
  // so as not to override any existing classes set by `EuiPortal`
  (0, _react.useEffect)(function () {
    if (overlayMaskNode) {
      overlayMaskNode.classList.add('euiOverlayMask', cssStyles);
      overlayMaskNode.dataset.relativeToHeader = headerZindexLocation;
      return function () {
        return overlayMaskNode.classList.remove(cssStyles);
      };
    }
  }, [overlayMaskNode, cssStyles, headerZindexLocation]);
  (0, _react.useEffect)(function () {
    if (className && overlayMaskNode) {
      var _overlayMaskNode$clas;
      var classNameArgs = className.split(' '); // The `classList` API doesn't support multiple classes in the same string
      (_overlayMaskNode$clas = overlayMaskNode.classList).add.apply(_overlayMaskNode$clas, _toConsumableArray(classNameArgs));
      return function () {
        var _overlayMaskNode$clas2;
        return (_overlayMaskNode$clas2 = overlayMaskNode.classList).remove.apply(_overlayMaskNode$clas2, _toConsumableArray(classNameArgs));
      };
    }
  }, [overlayMaskNode, className]);
  return (0, _react2.jsx)(_portal.EuiPortal, {
    portalRef: combinedMaskRef
  }, (0, _react2.jsx)(_react2.Global, {
    styles: _overlay_mask_body.euiOverlayMaskBodyStyles
  }), children);
};
exports.EuiOverlayMask = EuiOverlayMask;
EuiOverlayMask.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,
  /**
     * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
     */
  headerZindexLocation: _propTypes.default.oneOf(["above", "below"]),
  /**
     * React ref to be passed to the wrapping container
     */
  maskRef: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired])
};