"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExternalLinkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _react2 = require("@emotion/react");
var _excluded = ["target", "external"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * DRY util for indicating external links both via icon and to
 * screen readers. Used internally by at EuiLink and EuiListGroupItem
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var iconStyle = function iconStyle(_ref) {
  var euiTheme = _ref.euiTheme;
  return (0, _global_styling.logicalStyle)('margin-left', euiTheme.size.xs);
};
var EuiExternalLinkIcon = function EuiExternalLinkIcon(_ref2) {
  var target = _ref2.target,
    external = _ref2.external,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var iconCssStyle = (0, _services.useEuiMemoizedStyles)(iconStyle);
  var showExternalLinkIcon = target === '_blank' && external !== false || external === true;
  var iconAriaLabel = (0, _i18n.useEuiI18n)('euiExternalLinkIcon.ariaLabel', 'External link');
  return (0, _react2.jsx)(_react.default.Fragment, null, showExternalLinkIcon && (0, _react2.jsx)(_icon.EuiIcon, _extends({
    css: iconCssStyle,
    "aria-label": iconAriaLabel,
    size: "s",
    type: "popout"
  }, rest)), target === '_blank' && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiExternalLinkIcon.newTarget.screenReaderOnlyText",
    default: "(opens in a new tab or window)"
  }))));
};
exports.EuiExternalLinkIcon = EuiExternalLinkIcon;
EuiExternalLinkIcon.propTypes = {
  target: _propTypes.default.any,
  /**
     * Set to true to show an icon indicating that it is an external link;
     * Defaults to true if `target="_blank"`
     */
  external: _propTypes.default.bool
};