"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiKeyPadMenuVariables = exports.euiKeyPadMenuStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiKeyPadMenuVariables = function euiKeyPadMenuVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiKeyPadMenuSize: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 6;
    }),
    euiKeyPadMenuMarginSize: euiTheme.size.xs
  };
};
exports.euiKeyPadMenuVariables = euiKeyPadMenuVariables;
var euiKeyPadMenuStyles = function euiKeyPadMenuStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiKeyPadMenuVariabl = euiKeyPadMenuVariables(euiThemeContext),
    euiKeyPadMenuSize = _euiKeyPadMenuVariabl.euiKeyPadMenuSize,
    euiKeyPadMenuMarginSize = _euiKeyPadMenuVariabl.euiKeyPadMenuMarginSize;
  return {
    euiKeyPadMenu: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:row;flex-wrap:wrap;", (0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)([euiKeyPadMenuSize, euiKeyPadMenuMarginSize], function (x, y) {
      return x * 3 + y * 3;
    })), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " gap:", euiKeyPadMenuMarginSize, ";;label:euiKeyPadMenu;"),
    // Checkable = Fieldset and Legend
    euiKeyPadMenu__legend: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:euiKeyPadMenu__legend;")
  };
};
exports.euiKeyPadMenuStyles = euiKeyPadMenuStyles;