"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperSelectControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _accessibility = require("../../accessibility");
var _form_control_layout = require("../form_control_layout");
var _num_icons = require("../form_control_layout/_num_icons");
var _eui_form_context = require("../eui_form_context");
var _react2 = require("@emotion/react");
var _excluded = ["buttonRef", "className", "options", "id", "name", "fullWidth", "isLoading", "isInvalid", "readOnly", "defaultValue", "compressed", "value", "placeholder", "prepend", "append", "disabled"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiSuperSelectControl = function EuiSuperSelectControl(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var buttonRef = props.buttonRef,
    className = props.className,
    options = props.options,
    id = props.id,
    name = props.name,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$isInvalid = props.isInvalid,
    isInvalid = _props$isInvalid === void 0 ? false : _props$isInvalid,
    readOnly = props.readOnly,
    defaultValue = props.defaultValue,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    value = props.value,
    placeholder = props.placeholder,
    prepend = props.prepend,
    append = props.append,
    disabled = props.disabled,
    rest = _objectWithoutProperties(props, _excluded);
  var numIconsClass = (0, _num_icons.getFormControlClassNameForIconCount)({
    isInvalid: isInvalid,
    isLoading: isLoading,
    isDropdown: true
  });
  var classes = (0, _classnames.default)('euiSuperSelectControl', numIconsClass, {
    'euiSuperSelectControl--fullWidth': fullWidth,
    'euiSuperSelectControl--compressed': compressed,
    'euiSuperSelectControl--inGroup': prepend || append,
    'euiSuperSelectControl-isLoading': isLoading,
    'euiSuperSelectControl-isInvalid': isInvalid
  }, className);
  var inputValue = value != null ? value : defaultValue;
  var selectedValue = (0, _react.useMemo)(function () {
    if (inputValue != null) {
      var selectedOption = options === null || options === void 0 ? void 0 : options.find(function (option) {
        return option.value === inputValue;
      });
      return selectedOption ? selectedOption.inputDisplay : undefined;
    }
  }, [inputValue, options]);
  var showPlaceholder = !!placeholder && !selectedValue;

  // An extra screen reader workaround is required here to make sure `id`s
  // passed from EuiFormRow are inherited by the targetable <button> element
  var _useState = (0, _react.useState)(''),
    _useState2 = _slicedToArray(_useState, 2),
    formLabelId = _useState2[0],
    setFormLabelId = _useState2[1];
  var hasFormLabel = !!formLabelId;
  (0, _react.useEffect)(function () {
    if (id) {
      var formRowLabel = "".concat(id, "-label");
      var _hasFormLabel = !!document.getElementById(formRowLabel);
      if (_hasFormLabel) {
        setFormLabelId(formRowLabel);
      }
    }
  }, [id]);
  var buttonId = hasFormLabel ? "".concat(id, "-button") : undefined;
  var ariaLabelledBy = hasFormLabel ? "".concat(buttonId, " ").concat(formLabelId) : undefined;
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("input", {
    type: "hidden",
    id: id,
    name: name,
    value: String(inputValue !== null && inputValue !== void 0 ? inputValue : ''),
    readOnly: readOnly
  }), (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    isDropdown: true,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    readOnly: readOnly,
    compressed: compressed,
    prepend: prepend,
    append: append
  }, (0, _react2.jsx)("button", _extends({
    type: "button",
    className: classes,
    "aria-haspopup": "listbox",
    "aria-labelledby": ariaLabelledBy,
    id: buttonId,
    disabled: disabled || readOnly
    // @ts-ignore Using as a selector only for mixin use
    ,
    readOnly: readOnly
  }, rest, {
    ref: buttonRef
  }), showPlaceholder ? (0, _react2.jsx)("span", {
    className: "euiSuperSelectControl__placeholder"
  }, placeholder) : selectedValue, hasFormLabel &&
  // Add a slight pause between reading out the multiple aria-labelledby elements,
  // mimicking how screen readers handle native <select> elements
  (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, ", ")))));
};
exports.EuiSuperSelectControl = EuiSuperSelectControl;