"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutResizable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _resizable_container = require("../resizable_container");
var _helpers = require("../resizable_container/helpers");
var _flyout = require("./flyout");
var _flyout_resizable = require("./flyout_resizable.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "maxWidth", "minWidth", "onResize", "side", "type", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFlyoutResizable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var size = _ref.size,
    maxWidth = _ref.maxWidth,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 200 : _ref$minWidth,
    onResize = _ref.onResize,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_resizable.euiFlyoutResizableButtonStyles);
  var cssStyles = [styles.euiFlyoutResizableButton, styles[type][side]];
  var getFlyoutMinMaxWidth = (0, _react.useCallback)(function (width) {
    return Math.min(Math.max(width, minWidth), maxWidth || Infinity, window.innerWidth - 20 // Leave some offset
    );
  }, [minWidth, maxWidth]);
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    flyoutWidth = _useState2[0],
    setFlyoutWidth = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    callOnResize = _useState4[0],
    setCallOnResize = _useState4[1];

  // Must use state for the flyout ref in order for the useEffect to be correctly called after render
  var _useState5 = (0, _react.useState)(null),
    _useState6 = _slicedToArray(_useState5, 2),
    flyoutRef = _useState6[0],
    setFlyoutRef = _useState6[1];
  var setRefs = (0, _services.useCombinedRefs)([setFlyoutRef, ref]);
  (0, _react.useEffect)(function () {
    setCallOnResize(false); // Don't call `onResize` for non-user width changes
    setFlyoutWidth(flyoutRef ? getFlyoutMinMaxWidth(flyoutRef.offsetWidth) : 0);
  }, [flyoutRef, getFlyoutMinMaxWidth, size]);

  // Initial numbers to calculate from, on resize drag start
  var initialWidth = (0, _react.useRef)(0);
  var initialMouseX = (0, _react.useRef)(0);

  // Account for flyout side and logical property direction
  var direction = (0, _react.useMemo)(function () {
    var modifier = side === 'right' ? -1 : 1;
    if (flyoutRef) {
      var languageDirection = window.getComputedStyle(flyoutRef).direction;
      if (languageDirection === 'rtl') modifier *= -1;
    }
    return modifier;
  }, [side, flyoutRef]);
  var onMouseMove = (0, _react.useCallback)(function (e) {
    var mouseOffset = (0, _helpers.getPosition)(e, true) - initialMouseX.current;
    var changedFlyoutWidth = initialWidth.current + mouseOffset * direction;
    setFlyoutWidth(getFlyoutMinMaxWidth(changedFlyoutWidth));
  }, [getFlyoutMinMaxWidth, direction]);
  var onMouseUp = (0, _react.useCallback)(function () {
    setCallOnResize(true);
    initialMouseX.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove]);
  var onMouseDown = (0, _react.useCallback)(function (e) {
    var _flyoutRef$offsetWidt;
    setCallOnResize(false);
    initialMouseX.current = (0, _helpers.getPosition)(e, true);
    initialWidth.current = (_flyoutRef$offsetWidt = flyoutRef === null || flyoutRef === void 0 ? void 0 : flyoutRef.offsetWidth) !== null && _flyoutRef$offsetWidt !== void 0 ? _flyoutRef$offsetWidt : 0;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [flyoutRef, onMouseMove, onMouseUp]);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    setCallOnResize(true);
    var KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _services.keys.ARROW_RIGHT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth + KEYBOARD_OFFSET * direction);
        });
        break;
      case _services.keys.ARROW_LEFT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth - KEYBOARD_OFFSET * direction);
        });
    }
  }, [getFlyoutMinMaxWidth, direction]);

  // To reduce unnecessary calls, only fire onResize callback:
  // 1. After initial mount / on user width change events only
  // 2. If not currently mouse dragging
  (0, _react.useEffect)(function () {
    if (callOnResize) {
      onResize === null || onResize === void 0 ? void 0 : onResize(flyoutWidth);
    }
  }, [onResize, callOnResize, flyoutWidth]);
  return (0, _react2.jsx)(_flyout.EuiFlyout, _extends({}, rest, {
    size: flyoutWidth || size,
    maxWidth: maxWidth,
    side: side,
    type: type,
    ref: setRefs
  }), (0, _react2.jsx)(_resizable_container.EuiResizableButton, {
    isHorizontal: true,
    indicator: "border",
    css: cssStyles,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onKeyDown: onKeyDown
  }), children);
});
exports.EuiFlyoutResizable = EuiFlyoutResizable;
EuiFlyoutResizable.displayName = 'EuiFlyoutResizable';