"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutCloseButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _button = require("../button");
var _flyout_close_button = require("./_flyout_close_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "onClick", "onClose", "closeButtonPosition", "side"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFlyoutCloseButton = function EuiFlyoutCloseButton(_ref) {
  var className = _ref.className,
    _onClick = _ref.onClick,
    onClose = _ref.onClose,
    closeButtonPosition = _ref.closeButtonPosition,
    side = _ref.side,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiFlyout__closeButton', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_close_button.euiFlyoutCloseButtonStyles);
  var cssStyles = [styles.euiFlyout__closeButton, styles[closeButtonPosition], closeButtonPosition === 'outside' && styles.outsideSide[side]];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiFlyoutCloseButton.ariaLabel', 'Close this dialog');
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    display: closeButtonPosition === 'outside' ? 'fill' : 'empty',
    iconType: "cross",
    color: "text",
    "aria-label": ariaLabel,
    "data-test-subj": "euiFlyoutCloseButton"
  }, rest, {
    className: classes,
    css: cssStyles,
    onClick: function onClick(e) {
      onClose(e.nativeEvent);
      _onClick === null || _onClick === void 0 ? void 0 : _onClick(e);
    }
  }));
};
exports.EuiFlyoutCloseButton = EuiFlyoutCloseButton;