"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JUSTIFY_CONTENTS = exports.GUTTER_SIZES = exports.EuiFlexGroup = exports.DIRECTIONS = exports.COMPONENT_TYPES = exports.ALIGN_ITEMS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex_group = require("./flex_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "gutterSize", "alignItems", "responsive", "justifyContent", "direction", "wrap", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var GUTTER_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
exports.GUTTER_SIZES = GUTTER_SIZES;
var ALIGN_ITEMS = ['stretch', 'flexStart', 'flexEnd', 'center', 'baseline'];
exports.ALIGN_ITEMS = ALIGN_ITEMS;
var JUSTIFY_CONTENTS = ['flexStart', 'flexEnd', 'center', 'spaceBetween', 'spaceAround', 'spaceEvenly'];
exports.JUSTIFY_CONTENTS = JUSTIFY_CONTENTS;
var DIRECTIONS = ['row', 'rowReverse', 'column', 'columnReverse'];
exports.DIRECTIONS = DIRECTIONS;
var COMPONENT_TYPES = ['div', 'span'];
exports.COMPONENT_TYPES = COMPONENT_TYPES;
var EuiFlexGroup = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$justifyContent = _ref.justifyContent,
    justifyContent = _ref$justifyContent === void 0 ? 'flexStart' : _ref$justifyContent,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$wrap = _ref.wrap,
    wrap = _ref$wrap === void 0 ? false : _ref$wrap,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_flex_group.euiFlexGroupStyles);
  var cssStyles = [styles.euiFlexGroup, responsive && !direction.includes('column') && styles.responsive, wrap && styles.wrap, styles.gutterSizes[gutterSize], styles.justifyContent[justifyContent], styles.alignItems[alignItems], styles.direction[direction]];
  var classes = (0, _classnames.default)('euiFlexGroup', className);
  (0, _react.useEffect)(function () {
    if (!COMPONENT_TYPES.includes(component)) {
      throw new Error("".concat(component, " is not a valid element type. Use `div` or `span`."));
    }
  }, [component]);
  return component === 'span' ? (0, _react2.jsx)("span", _extends({
    css: cssStyles,
    className: classes,
    ref: ref
  }, rest), children) : (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes,
    ref: ref
  }, rest), children);
});
exports.EuiFlexGroup = EuiFlexGroup;
EuiFlexGroup.propTypes = {
  alignItems: _propTypes.default.any,
  component: _propTypes.default.any,
  direction: _propTypes.default.any,
  gutterSize: _propTypes.default.any,
  justifyContent: _propTypes.default.any,
  responsive: _propTypes.default.bool,
  wrap: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
EuiFlexGroup.displayName = 'EuiFlexGroup';