"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiFlexGrid = exports.DIRECTIONS = exports.ALIGN_ITEMS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex_grid = require("./flex_grid.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "style", "gutterSize", "direction", "alignItems", "responsive", "columns", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var DIRECTIONS = ['row', 'column'];
exports.DIRECTIONS = DIRECTIONS;
var ALIGN_ITEMS = ['stretch', 'start', 'end', 'center', 'baseline'];
exports.ALIGN_ITEMS = ALIGN_ITEMS;
var GUTTER_SIZES = ['none', 's', 'm', 'l', 'xl'];
exports.GUTTER_SIZES = GUTTER_SIZES;
var EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$columns = _ref.columns,
    columns = _ref$columns === void 0 ? 1 : _ref$columns,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiFlexGrid', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_flex_grid.euiFlexGridStyles);
  var cssStyles = [styles.euiFlexGrid, styles.gutterSizes[gutterSize], styles.direction[direction], styles.alignItems[alignItems], styles.columnCount[columns], responsive && styles.responsive];
  var columnDirectionStyles = (0, _react.useMemo)(function () {
    if (direction === 'column') {
      var rowsToRender = Math.ceil(_react.default.Children.count(children) / columns);
      return {
        gridTemplateRows: "repeat(".concat(rowsToRender, ", 1fr)")
      };
    }
  }, [direction, columns, children]);
  return (0, _react2.jsx)(Component, _extends({
    css: cssStyles,
    className: classes,
    style: columnDirectionStyles ? _objectSpread(_objectSpread({}, style), columnDirectionStyles) : style
  }, rest), children);
};
exports.EuiFlexGrid = EuiFlexGrid;
EuiFlexGrid.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,
  /**
     * Number of columns. Accepts `1-4`
     */
  columns: _propTypes.default.oneOf([1, 2, 3, 4]),
  // Leave this as inline so the props table correctly parses it
  /**
     * Flex layouts default to left-right then top-down (`row`).
     * Change this prop to `column` to create a top-down then left-right display.
     */
  direction: _propTypes.default.any,
  /**
     * Aligns grid items vertically
     */
  alignItems: _propTypes.default.any,
  /**
     * Space between flex items
     */
  gutterSize: _propTypes.default.any,
  /**
     * Will display each item at full-width on smaller screens
     */
  responsive: _propTypes.default.bool,
  /**
     * The tag to render
     * @default div
     */
  component: _propTypes.default.any
};