"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _inner_text = require("../inner_text");
var _badge = require("../badge");
var _button_empty = require("../button/button_empty");
var _filter_button = require("./filter_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "iconType", "iconSide", "color", "badgeColor", "hasActiveFilters", "numFilters", "numActiveFilters", "isDisabled", "isSelected", "type", "grow", "withNext", "textProps", "contentProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFilterButton = function EuiFilterButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'right' : _ref$iconSide,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$badgeColor = _ref.badgeColor,
    badgeColor = _ref$badgeColor === void 0 ? 'accent' : _ref$badgeColor,
    hasActiveFilters = _ref.hasActiveFilters,
    numFilters = _ref.numFilters,
    numActiveFilters = _ref.numActiveFilters,
    isDisabled = _ref.isDisabled,
    isSelected = _ref.isSelected,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    withNext = _ref.withNext,
    textProps = _ref.textProps,
    contentProps = _ref.contentProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var numFiltersDefined = numFilters != null; // != instead of !== to allow for null and undefined
  var numActiveFiltersDefined = numActiveFilters != null && numActiveFilters > 0;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _filter_button.euiFilterButtonStyles)(euiTheme);
  var cssStyles = [styles.euiFilterButton, withNext && styles.withNext, !grow && styles.noGrow, hasActiveFilters && styles.hasActiveFilters, numFiltersDefined && styles.hasNotification];
  var _euiFilterButtonChild = (0, _filter_button.euiFilterButtonChildStyles)(euiTheme),
    contentStyles = _euiFilterButtonChild.content,
    textStyles = _euiFilterButtonChild.text,
    notificationStyles = _euiFilterButtonChild.notification;
  var classes = (0, _classnames.default)('euiFilterButton', {
    'euiFilterButton-isSelected': isSelected,
    'euiFilterButton-hasActiveFilters': hasActiveFilters,
    'euiFilterButton-hasNotification': numFiltersDefined
  }, className);

  /**
   * Badge
   */
  var showBadge = numFiltersDefined || numActiveFiltersDefined;
  var badgeCount = numActiveFilters || numFilters;
  var activeBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeActiveAriaLabel', '{count} active filters', {
    count: badgeCount
  });
  var availableBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeAvailableAriaLabel', '{count} available filters', {
    count: badgeCount
  });
  var badgeContent = showBadge && (0, _react2.jsx)(_badge.EuiNotificationBadge, {
    className: "euiFilterButton__notification",
    css: [notificationStyles.euiFilterButton__notification, isDisabled && notificationStyles.disabled, ";label:badgeContent;"],
    "aria-label": hasActiveFilters ? activeBadgeLabel : availableBadgeLabel,
    color: isDisabled || !hasActiveFilters ? 'subdued' : badgeColor,
    role: "marquee" // https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/marquee_role
  }, badgeCount);

  /**
   * Text
   */
  var buttonTextClassNames = (0, _classnames.default)('euiFilterButton__text', {
    'euiFilterButton__text-hasNotification': showBadge
  }, textProps && textProps.className);
  var textCssStyles = [textStyles.euiFilterButton__text, showBadge && textStyles.hasNotification, textProps && textProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var dataText = children && typeof children === 'string' ? children : innerText;
  var textContent = (0, _react2.jsx)("span", _extends({
    ref: ref,
    "data-text": dataText,
    title: dataText
  }, textProps, {
    className: buttonTextClassNames,
    css: textCssStyles
  }), children);
  return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, _extends({
    className: classes,
    css: cssStyles,
    color: color,
    isDisabled: isDisabled,
    iconSide: iconSide,
    iconType: iconType,
    type: type,
    textProps: false,
    contentProps: _objectSpread(_objectSpread({}, contentProps), {}, {
      css: [contentStyles.euiFilterButton__content, iconType && contentStyles.hasIcon, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css]
    })
  }, rest), textContent, badgeContent);
};
exports.EuiFilterButton = EuiFilterButton;
EuiFilterButton.propTypes = {
  /**
     * Bolds the button if true
     */
  hasActiveFilters: _propTypes.default.bool,
  /**
     * Pass the total number of filters available and it will
     * add a subdued notification badge showing the number
     */
  numFilters: _propTypes.default.number,
  /**
     * Pass the number of selected filters and it will
     * add a bright notification badge showing the number
     */
  numActiveFilters: _propTypes.default.number,
  /**
     * Applies a visual state to the button useful when using with a popover.
     */
  isSelected: _propTypes.default.bool,
  /**
     * Should the button grow to fill its container, best used for dropdown buttons
     */
  grow: _propTypes.default.bool,
  /**
     * Remove border after button, good for opposite filters
     */
  withNext: _propTypes.default.bool,
  /**
     * Change color of the counter badge
     */
  badgeColor: _propTypes.default.any
};