"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiEmptyPromptStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "x4698b-roundedBorders",
  styles: "border-radius:inherit;label:roundedBorders;"
} : {
  name: "x4698b-roundedBorders",
  styles: "border-radius:inherit;label:roundedBorders;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "zv101j-euiEmptyPrompt__footer",
  styles: "border-end-end-radius:inherit;border-end-start-radius:inherit;label:euiEmptyPrompt__footer;"
} : {
  name: "zv101j-euiEmptyPrompt__footer",
  styles: "border-end-end-radius:inherit;border-end-start-radius:inherit;label:euiEmptyPrompt__footer;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1rdinfv-vertical",
  styles: "margin:auto;label:vertical;"
} : {
  name: "1rdinfv-vertical",
  styles: "margin:auto;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1w25ahh-vertical",
  styles: "justify-content:center;label:vertical;"
} : {
  name: "1w25ahh-vertical",
  styles: "justify-content:center;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "1o9qvqj-euiEmptyPrompt__main",
  styles: "display:flex;flex-direction:column;label:euiEmptyPrompt__main;"
} : {
  name: "1o9qvqj-euiEmptyPrompt__main",
  styles: "display:flex;flex-direction:column;label:euiEmptyPrompt__main;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiEmptyPromptStyles = function euiEmptyPromptStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var iconMaxWidth = (0, _global_styling.mathWithUnits)(euiTheme.size.l, function (x) {
    return x * 15;
  });
  var generatePaddingStyles = function generatePaddingStyles() {
    var property = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'padding';
    return {
      none: null,
      s: /*#__PURE__*/(0, _react.css)(property, ":", (0, _global_styling.euiPaddingSize)(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)(property, ":", (0, _global_styling.euiPaddingSize)(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/(0, _react.css)(property, ":", (0, _global_styling.euiPaddingSize)(euiThemeContext, 'l'), ";;label:l;")
    };
  };
  var generateFooterBorder = function generateFooterBorder(color) {
    return "".concat(euiTheme.border.width.thin, " solid ").concat((0, _global_styling.euiBorderColor)(euiThemeContext, color));
  };
  return {
    euiEmptyPrompt: /*#__PURE__*/(0, _react.css)("text-align:center;margin:auto;", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{", (0, _global_styling.logicalCSS)('max-width', 'max-content'), ";};label:euiEmptyPrompt;"),
    vertical: /*#__PURE__*/(0, _react.css)(";label:vertical;"),
    horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{justify-content:flex-start;text-align:start;};label:horizontal;"),
    main: _objectSpread(_objectSpread({
      euiEmptyPrompt__main: _ref5,
      vertical: _ref4,
      horizontal: /*#__PURE__*/(0, _react.css)("align-items:center;", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{flex-direction:row-reverse;};label:horizontal;")
    }, generatePaddingStyles()), {}, {
      horizontalPadding: generatePaddingStyles('gap')
    }),
    content: {
      euiEmptyPrompt__content: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '36em'), ";;label:euiEmptyPrompt__content;"),
      vertical: _ref3,
      horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{padding-block:", euiTheme.size.l, ";padding-inline:0;};label:horizontal;")
    },
    icon: {
      euiEmptyPrompt__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', iconMaxWidth), " margin:auto;&>*{flex-shrink:1;", (0, _global_styling.logicalCSS)('max-width', '100%'), ";};label:euiEmptyPrompt__icon;"),
      vertical: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:vertical;"),
      horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{", (0, _global_styling.logicalCSS)('min-width', '40%'), " ", (0, _global_styling.logicalCSS)('max-width', '50%'), "&&>*{", (0, _global_styling.logicalCSS)('max-width', iconMaxWidth), ";}};label:horizontal;")
    },
    actions: {
      euiEmptyPrompt__actions: /*#__PURE__*/(0, _react.css)(";label:euiEmptyPrompt__actions;"),
      vertical: /*#__PURE__*/(0, _react.css)(";label:vertical;"),
      horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiBreakpoint)(euiThemeContext, ['l', 'xl']), "{justify-content:flex-start;};label:horizontal;")
    },
    footer: _objectSpread({
      euiEmptyPrompt__footer: _ref2,
      roundedBorders: _ref,
      // Colors
      transparent: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.body, ";;label:transparent;"),
      plain: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.body, ";;label:plain;"),
      subdued: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('subdued')), ";;label:subdued;"),
      primary: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('primary')), ";;label:primary;"),
      accent: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('accent')), ";;label:accent;"),
      danger: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('danger')), ";;label:danger;"),
      warning: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('warning')), ";;label:warning;"),
      success: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', generateFooterBorder('success')), ";;label:success;")
    }, generatePaddingStyles())
  };
};
exports.euiEmptyPromptStyles = euiEmptyPromptStyles;