"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _drag_drop_context = require("./drag_drop_context");
var _services = require("./services");
var _draggable = require("./draggable");
var _droppable = require("./droppable");
var _panel = require("../panel");
var _services2 = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var makeId = (0, _services2.htmlIdGenerator)();
var makeList = function makeList(number) {
  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  return Array.from({
    length: number
  }, function (v, k) {
    return k + start;
  }).map(function (el) {
    return {
      content: "Item ".concat(el),
      id: makeId()
    };
  });
};
var DragAndDrop = function DragAndDrop() {
  var _useState = (0, _react.useState)(makeList(3)),
    _useState2 = _slicedToArray(_useState, 2),
    list = _useState2[0],
    setList = _useState2[1];
  var onDragEnd = function onDragEnd(_ref) {
    var source = _ref.source,
      destination = _ref.destination;
    if (source && destination) {
      var items = (0, _services.euiDragDropReorder)(list, source.index, destination.index);
      setList(items);
    }
  };
  return (0, _react2.jsx)(_drag_drop_context.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, (0, _react2.jsx)(_droppable.EuiDroppable, {
    droppableId: "DROPPABLE_AREA",
    spacing: "m",
    withPanel: true
  }, list.map(function (_ref2, idx) {
    var content = _ref2.content,
      id = _ref2.id;
    return (0, _react2.jsx)(_draggable.EuiDraggable, {
      spacing: "m",
      key: id,
      index: idx,
      draggableId: id,
      "data-test-subj": "cy-draggable-".concat(idx)
    }, function (provided, state) {
      return (0, _react2.jsx)(_panel.EuiPanel, {
        hasShadow: state.isDragging
      }, content, state.isDragging && ' ✨');
    });
  })));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(DragAndDrop, null));
});
describe('EuiDragDrop', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when an item is in draggable state', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when an item has been reordered and dropped', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.realPress('ArrowDown');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-2"]').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowUp');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-0"]').should('have.focus');
      cy.checkAxe();
    });
  });
});