"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelectPopover = exports.EuiQuickSelectPanels = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = require("../../../button");
var _icon = require("../../../icon");
var _popover = require("../../../popover");
var _title = require("../../../title");
var _text = require("../../../text");
var _i18n = require("../../../i18n");
var _quick_select = require("./quick_select");
var _commonly_used_time_ranges = require("./commonly_used_time_ranges");
var _recently_used = require("./recently_used");
var _refresh_interval = require("../../auto_refresh/refresh_interval");
var _react2 = require("@emotion/react");
var _excluded = ["applyTime"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiQuickSelectPopover = function EuiQuickSelectPopover(_ref) {
  var _applyTime = _ref.applyTime,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)(),
    _useState2 = _slicedToArray(_useState, 2),
    prevQuickSelect = _useState2[0],
    setQuickSelect = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setIsOpen(false);
  }, []);
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var applyTime = (0, _react.useCallback)(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end,
      quickSelect = _ref2.quickSelect,
      _ref2$keepPopoverOpen = _ref2.keepPopoverOpen,
      keepPopoverOpen = _ref2$keepPopoverOpen === void 0 ? false : _ref2$keepPopoverOpen;
    _applyTime({
      start: start,
      end: end
    });
    if (quickSelect) {
      setQuickSelect(quickSelect);
    }
    if (!keepPopoverOpen) {
      closePopover();
    }
  }, [_applyTime, closePopover]);
  var buttonlabel = (0, _i18n.useEuiI18n)('euiQuickSelectPopover.buttonLabel', 'Date quick select');
  var quickSelectButton = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    className: "euiFormControlLayout__prepend",
    contentProps: {
      className: 'euiQuickSelectPopover__buttonContent'
    },
    onClick: togglePopover,
    "aria-label": buttonlabel,
    title: buttonlabel,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    isDisabled: props.isDisabled,
    "data-test-subj": "superDatePickerToggleQuickMenuButton"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "calendar"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    button: quickSelectButton,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft"
  }, (0, _react2.jsx)(EuiQuickSelectPanels, _extends({}, props, {
    applyTime: applyTime,
    prevQuickSelect: prevQuickSelect
  })));
};
exports.EuiQuickSelectPopover = EuiQuickSelectPopover;
EuiQuickSelectPopover.propTypes = {
  applyRefreshInterval: _propTypes.default.func,
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),
  customQuickSelectRender: _propTypes.default.func,
  dateFormat: _propTypes.default.string.isRequired,
  end: _propTypes.default.string.isRequired,
  isDisabled: _propTypes.default.bool.isRequired,
  isPaused: _propTypes.default.bool.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  refreshInterval: _propTypes.default.number.isRequired,
  intervalUnits: _propTypes.default.oneOf(["s", "m", "h"]),
  start: _propTypes.default.string.isRequired,
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
var EuiQuickSelectPanels = function EuiQuickSelectPanels(_ref3) {
  var start = _ref3.start,
    end = _ref3.end,
    dateFormat = _ref3.dateFormat,
    timeOptions = _ref3.timeOptions,
    commonlyUsedRanges = _ref3.commonlyUsedRanges,
    recentlyUsedRanges = _ref3.recentlyUsedRanges,
    customQuickSelectPanels = _ref3.customQuickSelectPanels,
    customQuickSelectRender = _ref3.customQuickSelectRender,
    isPaused = _ref3.isPaused,
    refreshInterval = _ref3.refreshInterval,
    intervalUnits = _ref3.intervalUnits,
    applyRefreshInterval = _ref3.applyRefreshInterval,
    applyTime = _ref3.applyTime,
    prevQuickSelect = _ref3.prevQuickSelect;
  var quickSelectElement = (0, _react2.jsx)(_quick_select.EuiQuickSelect, {
    applyTime: applyTime,
    start: start,
    end: end,
    prevQuickSelect: prevQuickSelect,
    timeOptions: timeOptions
  });
  var commonlyUsedElement = (0, _react2.jsx)(_commonly_used_time_ranges.EuiCommonlyUsedTimeRanges, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges
  });
  var recentlyUsedElement = (0, _react2.jsx)(_recently_used.EuiRecentlyUsed, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges,
    dateFormat: dateFormat,
    recentlyUsedRanges: recentlyUsedRanges
  });
  var refreshIntervalElement = applyRefreshInterval && (0, _react2.jsx)(_refresh_interval.EuiRefreshInterval, {
    onRefreshChange: applyRefreshInterval,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    intervalUnits: intervalUnits
  });
  var customQuickSelectPanelsElement = (0, _react.useMemo)(function () {
    if (!customQuickSelectPanels) {
      return null;
    }
    return customQuickSelectPanels.map(function (_ref4) {
      var title = _ref4.title,
        content = _ref4.content;
      return (0, _react2.jsx)("div", {
        key: title,
        className: "euiQuickSelectPopover__panel"
      }, (0, _react2.jsx)(_title.EuiTitle, {
        size: "xxxs"
      }, (0, _react2.jsx)("span", null, title)), (0, _react2.jsx)(_text.EuiText, {
        size: "s",
        className: "euiQuickSelectPopover__section"
      }, /*#__PURE__*/_react.default.cloneElement(content, {
        applyTime: applyTime
      })));
    });
  }, [customQuickSelectPanels, applyTime]);
  return (0, _react2.jsx)("div", {
    className: "euiQuickSelectPopover__content",
    "data-test-subj": "superDatePickerQuickMenu"
  }, customQuickSelectRender ? customQuickSelectRender({
    quickSelect: quickSelectElement,
    commonlyUsedRanges: commonlyUsedElement,
    recentlyUsedRanges: recentlyUsedElement,
    refreshInterval: refreshIntervalElement,
    customQuickSelectPanels: customQuickSelectPanelsElement
  }) : (0, _react2.jsx)(_react.default.Fragment, null, quickSelectElement, commonlyUsedElement, recentlyUsedElement, refreshIntervalElement, customQuickSelectPanelsElement));
};
exports.EuiQuickSelectPanels = EuiQuickSelectPanels;
EuiQuickSelectPanels.propTypes = {
  prevQuickSelect: _propTypes.default.shape({
    timeTense: _propTypes.default.string.isRequired,
    timeValue: _propTypes.default.number.isRequired,
    timeUnits: _propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired
  })
};