"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAbsoluteTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _services = require("../../../../services");
var _form = require("../../../form");
var _code = require("../../../code");
var _i18n = require("../../../i18n");
var _date_picker = require("../../date_picker");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */ // eslint-disable-line import/named
// Allow users to paste in and have the datepicker parse multiple common date formats,
// in addition to the configured displayed `dateFormat` prop
var ALLOWED_USER_DATE_FORMATS = [_moment.default.ISO_8601, _moment.default.RFC_2822, 'X' // Unix timestamp in seconds
];
var EuiAbsoluteTab = /*#__PURE__*/function (_Component) {
  _inherits(EuiAbsoluteTab, _Component);
  var _super = _createSuper(EuiAbsoluteTab);
  // Store outside of state as a ref for faster/unbatched updates

  function EuiAbsoluteTab(props) {
    var _this;
    _classCallCheck(this, EuiAbsoluteTab);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "state", void 0);
    _defineProperty(_assertThisInitialized(_this), "isParsing", false);
    _defineProperty(_assertThisInitialized(_this), "handleChange", function (date) {
      var onChange = _this.props.onChange;
      if (date === null) {
        return;
      }
      onChange(date.toISOString());
      var valueAsMoment = (0, _moment.default)(date);
      _this.setState({
        valueAsMoment: valueAsMoment,
        textInputValue: valueAsMoment.format(_this.props.dateFormat),
        hasUnparsedText: false,
        isTextInvalid: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "handleTextChange", function (event) {
      if (_this.isParsing) return;
      _this.setState({
        textInputValue: event.target.value,
        hasUnparsedText: true,
        isTextInvalid: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "parseUserDateInput", function (textInputValue) {
      _this.isParsing = true;
      // Wait a tick for state to finish updating (whatever gets returned),
      // and then allow `onChange` user input to continue setting state
      requestAnimationFrame(function () {
        _this.isParsing = false;
      });
      var invalidDateState = {
        textInputValue: textInputValue,
        isTextInvalid: true,
        valueAsMoment: null
      };
      if (!textInputValue) {
        return _this.setState(invalidDateState);
      }
      var _this$props = _this.props,
        onChange = _this$props.onChange,
        dateFormat = _this$props.dateFormat;

      // Attempt to parse with passed `dateFormat`
      var valueAsMoment = (0, _moment.default)(textInputValue, dateFormat, true);
      var dateIsValid = valueAsMoment.isValid();

      // If not valid, try a few other other standardized formats
      if (!dateIsValid) {
        valueAsMoment = (0, _moment.default)(textInputValue, ALLOWED_USER_DATE_FORMATS, true);
        dateIsValid = valueAsMoment.isValid();
      }
      if (dateIsValid) {
        onChange(valueAsMoment.toISOString());
        _this.setState({
          textInputValue: valueAsMoment.format(_this.props.dateFormat),
          valueAsMoment: valueAsMoment,
          hasUnparsedText: false,
          isTextInvalid: false
        });
      } else {
        _this.setState(invalidDateState);
      }
    });
    var parsedValue = _datemath.default.parse(props.value, {
      roundUp: props.roundUp
    });
    var _valueAsMoment = parsedValue && parsedValue.isValid() ? parsedValue : (0, _moment.default)();
    var _textInputValue = _valueAsMoment.locale(_this.props.locale || 'en').format(_this.props.dateFormat);
    _this.state = {
      hasUnparsedText: false,
      isTextInvalid: false,
      textInputValue: _textInputValue,
      valueAsMoment: _valueAsMoment
    };
    return _this;
  }
  _createClass(EuiAbsoluteTab, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        dateFormat = _this$props2.dateFormat,
        timeFormat = _this$props2.timeFormat,
        locale = _this$props2.locale,
        utcOffset = _this$props2.utcOffset,
        labelPrefix = _this$props2.labelPrefix;
      var _this$state = this.state,
        valueAsMoment = _this$state.valueAsMoment,
        isTextInvalid = _this$state.isTextInvalid,
        hasUnparsedText = _this$state.hasUnparsedText,
        textInputValue = _this$state.textInputValue;
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_date_picker.EuiDatePicker, {
        inline: true,
        showTimeSelect: true,
        shadow: false,
        selected: valueAsMoment,
        onChange: this.handleChange,
        dateFormat: dateFormat,
        timeFormat: timeFormat,
        locale: locale,
        utcOffset: utcOffset
      }), (0, _react2.jsx)(_i18n.EuiI18n, {
        tokens: ['euiAbsoluteTab.dateFormatHint', 'euiAbsoluteTab.dateFormatError'],
        defaults: ['Press the Enter key to parse as a date.', 'Allowed formats: {dateFormat}, ISO 8601, RFC 2822, or Unix timestamp.'],
        values: {
          dateFormat: (0, _react2.jsx)(_code.EuiCode, null, dateFormat)
        }
      }, function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          dateFormatHint = _ref2[0],
          dateFormatError = _ref2[1];
        return (0, _react2.jsx)(_form.EuiFormRow, {
          className: "euiSuperDatePicker__absoluteDateFormRow",
          isInvalid: isTextInvalid,
          error: isTextInvalid ? dateFormatError : undefined,
          helpText: hasUnparsedText ? isTextInvalid ? dateFormatHint : [dateFormatHint, dateFormatError] : undefined
        }, (0, _react2.jsx)(_form.EuiFieldText, {
          compressed: true,
          isInvalid: isTextInvalid,
          value: textInputValue,
          onChange: _this2.handleTextChange,
          onPaste: function onPaste(event) {
            _this2.parseUserDateInput(event.clipboardData.getData('text'));
          },
          onKeyDown: function onKeyDown(event) {
            if (event.key === _services.keys.ENTER) {
              _this2.parseUserDateInput(textInputValue);
            }
          },
          "data-test-subj": "superDatePickerAbsoluteDateInput",
          prepend: (0, _react2.jsx)(_form.EuiFormLabel, null, labelPrefix)
        }));
      }));
    }
  }]);
  return EuiAbsoluteTab;
}(_react.Component);
exports.EuiAbsoluteTab = EuiAbsoluteTab;
EuiAbsoluteTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  timeFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool.isRequired,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired,
  labelPrefix: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number
};