"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePickerRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form = require("../form");
var _services = require("../../services");
var _date_picker_range = require("./date_picker_range.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "startDateControl", "endDateControl", "iconType", "inline", "shadow", "fullWidth", "compressed", "isCustom", "readOnly", "isLoading", "isInvalid", "disabled", "onFocus", "onBlur", "append", "prepend"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiDatePickerRange = function EuiDatePickerRange(_ref) {
  var children = _ref.children,
    className = _ref.className,
    startDateControl = _ref.startDateControl,
    endDateControl = _ref.endDateControl,
    _ref$iconType = _ref.iconType,
    iconType = _ref$iconType === void 0 ? true : _ref$iconType,
    inline = _ref.inline,
    _ref$shadow = _ref.shadow,
    shadow = _ref$shadow === void 0 ? true : _ref$shadow,
    _fullWidth = _ref.fullWidth,
    _compressed = _ref.compressed,
    isCustom = _ref.isCustom,
    readOnly = _ref.readOnly,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    _onFocus = _ref.onFocus,
    _onBlur = _ref.onBlur,
    append = _ref.append,
    prepend = _ref.prepend,
    rest = _objectWithoutProperties(_ref, _excluded);
  // `fullWidth` and `compressed` should not affect inline datepickers (matches non-range behavior)
  var fullWidth = _fullWidth && !inline;
  var compressed = _compressed && !inline;
  var classes = (0, _classnames.default)('euiDatePickerRange', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _date_picker_range.euiDatePickerRangeStyles)(euiTheme);
  var cssStyles = [styles.euiDatePickerRange];
  if (inline) {
    // Determine the inline container query to use based on the width of the react-datepicker
    var hasTimeSelect = startDateControl.props.showTimeSelect || endDateControl.props.showTimeSelect;
    var inlineStyles = (0, _date_picker_range.euiDatePickerRangeInlineStyles)(euiTheme);
    cssStyles.push(inlineStyles.inline);
    cssStyles.push(hasTimeSelect ? inlineStyles.responsiveWithTimeSelect : inlineStyles.responsive);
    if (shadow) cssStyles.push(inlineStyles.shadow);
  }
  var startControl = startDateControl;
  var endControl = endDateControl;
  if (!isCustom) {
    startControl = /*#__PURE__*/(0, _react.cloneElement)(startDateControl, {
      controlOnly: true,
      showIcon: false,
      inline: inline,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || startDateControl.props.disabled,
      isInvalid: isInvalid || startDateControl.props.isInvalid,
      className: (0, _classnames.default)('euiDatePickerRange__start', startDateControl.props.className),
      onBlur: function onBlur(event) {
        var _startDateControl$pro, _startDateControl$pro2;
        (_startDateControl$pro = startDateControl.props) === null || _startDateControl$pro === void 0 ? void 0 : (_startDateControl$pro2 = _startDateControl$pro.onBlur) === null || _startDateControl$pro2 === void 0 ? void 0 : _startDateControl$pro2.call(_startDateControl$pro, event);
        _onBlur === null || _onBlur === void 0 ? void 0 : _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _startDateControl$pro3, _startDateControl$pro4;
        (_startDateControl$pro3 = startDateControl.props) === null || _startDateControl$pro3 === void 0 ? void 0 : (_startDateControl$pro4 = _startDateControl$pro3.onFocus) === null || _startDateControl$pro4 === void 0 ? void 0 : _startDateControl$pro4.call(_startDateControl$pro3, event);
        _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(event);
      }
    });
    endControl = /*#__PURE__*/(0, _react.cloneElement)(endDateControl, {
      controlOnly: true,
      showIcon: false,
      inline: inline,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || endDateControl.props.disabled,
      isInvalid: isInvalid || endDateControl.props.isInvalid,
      popoverPlacement: 'downRight',
      className: (0, _classnames.default)('euiDatePickerRange__end', endDateControl.props.className),
      onBlur: function onBlur(event) {
        var _endDateControl$props, _endDateControl$props2;
        (_endDateControl$props = endDateControl.props) === null || _endDateControl$props === void 0 ? void 0 : (_endDateControl$props2 = _endDateControl$props.onBlur) === null || _endDateControl$props2 === void 0 ? void 0 : _endDateControl$props2.call(_endDateControl$props, event);
        _onBlur === null || _onBlur === void 0 ? void 0 : _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _endDateControl$props3, _endDateControl$props4;
        (_endDateControl$props3 = endDateControl.props) === null || _endDateControl$props3 === void 0 ? void 0 : (_endDateControl$props4 = _endDateControl$props3.onFocus) === null || _endDateControl$props4 === void 0 ? void 0 : _endDateControl$props4.call(_endDateControl$props3, event);
        _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(event);
      }
    });
  }
  var icon = (0, _react.useMemo)(function () {
    if (inline) return undefined;
    if (iconType === false) return undefined;
    if (iconType === true) return 'calendar';
    return iconType;
  }, [iconType, inline]);
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), (0, _react2.jsx)(_form.EuiFormControlLayoutDelimited, {
    icon: icon,
    startControl: startControl,
    endControl: endControl,
    fullWidth: fullWidth,
    compressed: compressed,
    readOnly: readOnly,
    isDisabled: disabled,
    isInvalid: isInvalid,
    isLoading: isLoading,
    append: inline ? undefined : append,
    prepend: inline ? undefined : prepend
  }));
};
exports.EuiDatePickerRange = EuiDatePickerRange;
EuiDatePickerRange.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Including any children will replace all innards with the provided children
       */
  children: _propTypes.default.node,
  /**
       * The end date `EuiDatePicker` element
       */
  endDateControl: _propTypes.default.element.isRequired,
  /**
       * The start date `EuiDatePicker` element
       */
  startDateControl: _propTypes.default.element.isRequired,
  /**
       * Pass either an icon type or set to `false` to remove icon entirely
       */
  iconType: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired]),
  /**
       * Won't apply any additional props to start and end date components
       */
  isCustom: _propTypes.default.bool,
  /**
       * Passes through to each control
       */
  disabled: _propTypes.default.bool,
  /**
       * Displays both date picker calendars directly on the page.
       * Will not render `iconType`, `fullWidth`, `prepend`, or `append`.
       *
       * Passes through to each control if `isCustom` is not set.
       */
  inline: _propTypes.default.bool,
  /**
       * Allows turning the shadow off if using the `inline` prop
       */
  shadow: _propTypes.default.bool,
  /**
       * Triggered whenever the start or end controls are blurred
       */
  onBlur: _propTypes.default.any,
  /**
       * Triggered whenever the start or end controls are focused
       */
  onFocus: _propTypes.default.any
};