"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridColumnSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _button = require("../../button");
var _flex = require("../../flex");
var _form = require("../../form");
var _drag_and_drop = require("../../drag_and_drop");
var _icon = require("../../icon");
var _services = require("../../../services");
var _data_grid_toolbar = require("./data_grid_toolbar");
var _data_grid_toolbar_control = require("./data_grid_toolbar_control");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
var useDataGridColumnSelector = function useDataGridColumnSelector(availableColumns, columnVisibility, showColumnSelector, displayValues) {
  var allowColumnHiding = (0, _data_grid_toolbar.getNestedObjectOptions)(showColumnSelector, 'allowHide');
  var allowColumnReorder = (0, _data_grid_toolbar.getNestedObjectOptions)(showColumnSelector, 'allowReorder');
  var _useDependentState = (0, _services.useDependentState)(function () {
      return availableColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      });
    }, [availableColumns]),
    _useDependentState2 = _slicedToArray(_useDependentState, 2),
    sortedColumns = _useDependentState2[0],
    setSortedColumns = _useDependentState2[1];
  var visibleColumns = columnVisibility.visibleColumns,
    setVisibleColumns = columnVisibility.setVisibleColumns;
  var visibleColumnIds = (0, _react.useMemo)(function () {
    return new Set(visibleColumns);
  }, [visibleColumns]);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var setColumns = (0, _react.useCallback)(function (nextColumns) {
    setSortedColumns(nextColumns);
    var nextVisibleColumns = nextColumns.filter(function (id) {
      return visibleColumnIds.has(id);
    });
    setVisibleColumns(nextVisibleColumns);
  }, [setSortedColumns, setVisibleColumns, visibleColumnIds]);
  var onDragEnd = (0, _react.useCallback)(function (_ref2) {
    var sourceIndex = _ref2.source.index,
      destination = _ref2.destination;
    if (destination) {
      var destinationIndex = destination.index;
      var nextSortedColumns = (0, _drag_and_drop.euiDragDropReorder)(sortedColumns, sourceIndex, destinationIndex);
      setColumns(nextSortedColumns);
    }
  }, [sortedColumns, setColumns]);
  var numberOfHiddenFields = availableColumns.length - visibleColumns.length;
  var _useState3 = (0, _react.useState)(''),
    _useState4 = _slicedToArray(_useState3, 2),
    columnSearchText = _useState4[0],
    setColumnSearchText = _useState4[1];
  var filteredColumns = (0, _react.useMemo)(function () {
    return sortedColumns.filter(function (id) {
      return (displayValues[id] || id).toLowerCase().indexOf(columnSearchText.toLowerCase()) !== -1;
    });
  }, [sortedColumns, columnSearchText, displayValues]);
  var isDragEnabled = allowColumnReorder && columnSearchText.length === 0; // only allow drag-and-drop when not filtering columns
  var dragHandleAriaLabel = (0, _i18n.useEuiI18n)('euiColumnSelector.dragHandleAriaLabel', 'Drag handle');
  var orderedVisibleColumns = (0, _react.useMemo)(function () {
    return visibleColumns.map(function (columnId) {
      return availableColumns.find(function (_ref3) {
        var id = _ref3.id;
        return id === columnId;
      });
    } // cast to avoid `undefined`, it filters those out next
    ).filter(function (column) {
      return column != null;
    });
  }, [availableColumns, visibleColumns]);
  var columnSelector = (0, _react.useMemo)(function () {
    return allowColumnHiding || allowColumnReorder ? (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridColumnSelectorPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downLeft",
      panelPaddingSize: "s",
      hasDragDrop: true,
      button: (0, _react2.jsx)(_data_grid_toolbar_control.EuiDataGridToolbarControl, {
        badgeContent: numberOfHiddenFields > 0 ? "".concat(orderedVisibleColumns.length, "/").concat(availableColumns.length) : availableColumns.length,
        iconType: "tableDensityNormal",
        "data-test-subj": "dataGridColumnSelectorButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        }
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiColumnSelector.button",
        default: "Columns"
      }))
    }, allowColumnHiding && (0, _react2.jsx)(_popover.EuiPopoverTitle, null, (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiColumnSelector.search', 'euiColumnSelector.searchcolumns'],
      defaults: ['Search', 'Search columns']
    }, function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        search = _ref5[0],
        searchcolumns = _ref5[1];
      return (0, _react2.jsx)(_form.EuiFieldText, {
        compressed: true,
        placeholder: search,
        "aria-label": searchcolumns,
        value: columnSearchText,
        onChange: function onChange(e) {
          return setColumnSearchText(e.currentTarget.value);
        },
        "data-test-subj": "dataGridColumnSelectorSearch"
      });
    })), (0, _react2.jsx)(_drag_and_drop.EuiDragDropContext, {
      onDragEnd: onDragEnd
    }, (0, _react2.jsx)(_drag_and_drop.EuiDroppable, {
      droppableId: "columnOrder",
      isDropDisabled: !isDragEnabled,
      className: "euiDataGrid__controlScroll"
    }, (0, _react2.jsx)(_react.default.Fragment, null, filteredColumns.map(function (id, index) {
      return (0, _react2.jsx)(_drag_and_drop.EuiDraggable, {
        key: id,
        draggableId: id,
        index: index,
        isDragDisabled: !isDragEnabled,
        hasInteractiveChildren: true,
        customDragHandle: true
      }, function (provided, state) {
        return (0, _react2.jsx)("div", {
          className: (0, _classnames.default)('euiDataGridColumnSelector__item', {
            'euiDataGridColumnSelector__item-isDragging': state.isDragging
          }),
          "data-test-subj": "dataGridColumnSelectorColumnItem-".concat(id)
        }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
          responsive: false,
          gutterSize: "s",
          alignItems: "center"
        }, allowColumnHiding && (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_form.EuiSwitch, {
          name: id,
          label: displayValues[id] || id,
          showLabel: false,
          checked: visibleColumnIds.has(id),
          compressed: true,
          className: "euiSwitch--mini",
          onChange: function onChange(event) {
            var checked = event.target.checked;
            var nextVisibleColumns = sortedColumns.filter(function (columnId) {
              return checked ? visibleColumnIds.has(columnId) || id === columnId : visibleColumnIds.has(columnId) && id !== columnId;
            });
            setVisibleColumns(nextVisibleColumns);
          },
          "data-test-subj": "dataGridColumnSelectorToggleColumnVisibility-".concat(id)
        })), (0, _react2.jsx)(_flex.EuiFlexItem
        // This extra column name flex item affords the column more grabbable real estate
        // for mouse users, while hiding repetition for keyboard/screen reader users
        , _extends({}, provided.dragHandleProps, {
          "aria-hidden": true,
          tabIndex: -1
        }), (0, _react2.jsx)("span", {
          className: "euiDataGridColumnSelector__itemLabel"
        }, displayValues[id] || id)), isDragEnabled && (0, _react2.jsx)(_flex.EuiFlexItem, _extends({
          grow: false
        }, provided.dragHandleProps, {
          "aria-label": dragHandleAriaLabel
        }), (0, _react2.jsx)(_icon.EuiIcon, {
          type: "grab",
          color: "subdued"
        }))));
      });
    })))), allowColumnHiding && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      justifyContent: "spaceBetween"
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      onClick: function onClick() {
        return setVisibleColumns(sortedColumns);
      },
      "data-test-subj": "dataGridColumnSelectorShowAllButton"
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSelector.selectAll",
      default: "Show all"
    }))), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      onClick: function onClick() {
        return setVisibleColumns([]);
      },
      "data-test-subj": "dataGridColumnSelectorHideAllButton"
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSelector.hideAll",
      default: "Hide all"
    })))))) : null;
  }, [availableColumns.length, numberOfHiddenFields, orderedVisibleColumns.length, allowColumnHiding, allowColumnReorder, isOpen, columnSearchText, displayValues, visibleColumnIds, sortedColumns, setVisibleColumns, setIsOpen, onDragEnd, isDragEnabled, dragHandleAriaLabel, filteredColumns]);

  /**
   * Used for moving columns left/right, available in the headers actions menu
   */
  var switchColumnPos = (0, _react.useCallback)(function (fromColId, toColId) {
    var moveFromIdx = sortedColumns.indexOf(fromColId);
    var moveToIdx = sortedColumns.indexOf(toColId);
    if (moveFromIdx === -1 || moveToIdx === -1) {
      return;
    }
    var nextSortedColumns = _toConsumableArray(sortedColumns);
    nextSortedColumns.splice(moveFromIdx, 1);
    nextSortedColumns.splice(moveToIdx, 0, fromColId);
    setColumns(nextSortedColumns);
  }, [setColumns, sortedColumns]);
  return (0, _react.useMemo)(function () {
    return [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos];
  }, [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos]);
};
exports.useDataGridColumnSelector = useDataGridColumnSelector;