"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridControlHeaderCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _data_grid_header_cell_wrapper = require("./data_grid_header_cell_wrapper");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /*
                                                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                     */
var EuiDataGridControlHeaderCell = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var controlColumn = _ref.controlColumn,
    index = _ref.index;
  var HeaderCellRender = controlColumn.headerCellRender,
    headerCellProps = controlColumn.headerCellProps,
    width = controlColumn.width,
    id = controlColumn.id;
  return (0, _react2.jsx)(_data_grid_header_cell_wrapper.EuiDataGridHeaderCellWrapper, _extends({}, headerCellProps, {
    className: (0, _classnames.default)('euiDataGridHeaderCell--controlColumn', headerCellProps === null || headerCellProps === void 0 ? void 0 : headerCellProps.className),
    id: id,
    index: index,
    width: width
  }), (0, _react2.jsx)("div", {
    className: "euiDataGridHeaderCell__content"
  }, (0, _react2.jsx)(HeaderCellRender, null)));
});
exports.EuiDataGridControlHeaderCell = EuiDataGridControlHeaderCell;
EuiDataGridControlHeaderCell.propTypes = {
  index: _propTypes.default.number.isRequired,
  controlColumn: _propTypes.default.shape({
    /**
       * Used as the React `key` when rendering content
       */
    id: _propTypes.default.string.isRequired,
    /**
       * Width of the column, users are unable to change this
       */
    width: _propTypes.default.number.isRequired,
    /**
       * Component to render in the column header
       */
    headerCellRender: _propTypes.default.elementType.isRequired,
    /**
       * Optional props to pass to the column header cell
       */
    headerCellProps: _propTypes.default.any,
    /**
       * Component to render for each row in the column
       */
    rowCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.element.isRequired]).isRequired,
    /**
       * Component to render in the optional column footer
       */
    footerCellRender: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.element.isRequired]),
    /**
       * Optional props to pass to the column footer cell
       */
    footerCellProps: _propTypes.default.any
  }).isRequired
};
EuiDataGridControlHeaderCell.displayName = 'EuiDataGridControlHeaderCell';