"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridFooterRow = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _cell = require("../cell");
var _react2 = require("@emotion/react");
var _excluded = ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "renderCellPopover", "rowIndex", "interactiveCellId", "data-test-subj", "visibleRowIndex"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var renderEmpty = function renderEmpty() {
  return null;
};
var EuiDataGridFooterRow = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    columns = _ref.columns,
    schema = _ref.schema,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    className = _ref.className,
    renderCellValue = _ref.renderCellValue,
    renderCellPopover = _ref.renderCellPopover,
    rowIndex = _ref.rowIndex,
    interactiveCellId = _ref.interactiveCellId,
    _dataTestSubj = _ref['data-test-subj'],
    _ref$visibleRowIndex = _ref.visibleRowIndex,
    visibleRowIndex = _ref$visibleRowIndex === void 0 ? rowIndex : _ref$visibleRowIndex,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDataGridRow', {
    'euiDataGridRow--striped': visibleRowIndex % 2 !== 0
  }, 'euiDataGridFooter', className);
  var dataTestSubj = (0, _classnames.default)('dataGridRow', 'dataGridFooterRow', _dataTestSubj);
  var popoverContext = (0, _react.useContext)(_cell.DataGridCellPopoverContext);
  var sharedCellProps = {
    rowIndex: rowIndex,
    visibleRowIndex: visibleRowIndex,
    interactiveCellId: interactiveCellId,
    popoverContext: popoverContext
  };
  return (0, _react2.jsx)("div", _extends({
    ref: ref,
    role: "row",
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (_ref2, i) {
    var id = _ref2.id,
      width = _ref2.width,
      footerCellRender = _ref2.footerCellRender,
      footerCellProps = _ref2.footerCellProps;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, _extends({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: i,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: (0, _classnames.default)('euiDataGridFooterCell', 'euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className)
    }));
  }), columns.map(function (_ref3, i) {
    var id = _ref3.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      key: "".concat(columnPosition, ",").concat(visibleRowIndex) // Note: this key should use cell position to match react-window/data cell behavior. See #5720
      ,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      isExpandable: true,
      className: "euiDataGridFooterCell"
    }));
  }), trailingControlColumns.map(function (_ref4, i) {
    var id = _ref4.id,
      width = _ref4.width,
      footerCellRender = _ref4.footerCellRender,
      footerCellProps = _ref4.footerCellProps;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, _extends({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: colIndex,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: (0, _classnames.default)('euiDataGridFooterCell', 'euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className)
    }));
  }));
}));
exports.EuiDataGridFooterRow = EuiDataGridFooterRow;
EuiDataGridFooterRow.displayName = 'EuiDataGridFooterRow';