"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HandleInteractiveChildren = exports.FocusTrappedChildren = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tabbable = require("tabbable");
var _services = require("../../../../services");
var _focus_trap = require("../../../focus_trap");
var _accessibility = require("../../../accessibility");
var _i18n = require("../../../i18n");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /**
                                                                           * This internal utility component is used by all cells, both header and body/footer cells.
                                                                           * It always handles:
                                                                           *   1. Removing any interactive children from keyboard tab order on cell mount
                                                                           *   2. Listening for focus on any interactive children and updating the cell focus context
                                                                           *
                                                                           * It should *only* render focus traps for:
                                                                           *   1. Header cells that are `actions: false` but still have interactive children
                                                                           *   2. Body cells that are `isExpandable: false` but still have interactive children
                                                                           */
var HandleInteractiveChildren = function HandleInteractiveChildren(_ref) {
  var cellEl = _ref.cellEl,
    children = _ref.children,
    updateCellFocusContext = _ref.updateCellFocusContext,
    renderFocusTrap = _ref.renderFocusTrap;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    hasInteractiveChildren = _useState2[0],
    setHasInteractiveChildren = _useState2[1];

  // On mount, disable all interactive children
  (0, _react.useEffect)(function () {
    if (cellEl) {
      var interactiveChildren = disableInteractives(cellEl);
      if (renderFocusTrap) {
        setHasInteractiveChildren(interactiveChildren.length > 0);
      }
    }
  }, [cellEl, renderFocusTrap]);

  // Ensure that any interactive children that are clicked update the latest cell focus context
  (0, _react.useEffect)(function () {
    if (cellEl) {
      var onFocus = function onFocus() {
        return updateCellFocusContext();
      };
      cellEl.addEventListener('focus', onFocus, true); // useCapture listens for focus on children
      return function () {
        cellEl.removeEventListener('focus', onFocus, true);
      };
    }
  }, [cellEl, updateCellFocusContext]);
  var _children = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_react.default.Fragment, null, children);
  }, [children]);
  if (!cellEl) return _children; // Do nothing if cell has yet to mount or is unmounting
  if (!renderFocusTrap) return _children; // Cells with default actions / expansion popovers do not need to trap
  if (!hasInteractiveChildren) return _children; // No need to focus trap if no children are interactive

  return (0, _react2.jsx)(FocusTrappedChildren, {
    cellEl: cellEl
  }, children);
};

/**
 * Cells with interactive children but no cell popover expansion should render a
 * focus trap that can be entered with the Enter key, which cycles keyboard tabs
 * through the cell contents only, and exited with the Escape key
 */
exports.HandleInteractiveChildren = HandleInteractiveChildren;
HandleInteractiveChildren.propTypes = {
  cellEl: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])]),
  updateCellFocusContext: _propTypes.default.func.isRequired,
  renderFocusTrap: _propTypes.default.bool
};
var FocusTrappedChildren = function FocusTrappedChildren(_ref2) {
  var cellEl = _ref2.cellEl,
    children = _ref2.children;
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isCellEntered = _useState4[0],
    setIsCellEntered = _useState4[1];
  (0, _react.useEffect)(function () {
    if (isCellEntered) {
      enableAndFocusInteractives(cellEl);
    } else {
      disableInteractives(cellEl);
    }
  }, [isCellEntered, cellEl]);
  (0, _react.useEffect)(function () {
    var onKeyUp = function onKeyUp(event) {
      switch (event.key) {
        case _services.keys.ENTER:
        case _services.keys.F2:
          event.preventDefault();
          setIsCellEntered(true);
          break;
        case _services.keys.ESCAPE:
          event.preventDefault();
          setIsCellEntered(function (isCellEntered) {
            if (isCellEntered === true) {
              requestAnimationFrame(function () {
                return cellEl.focus();
              }); // move focus to cell
              return false;
            }
            return isCellEntered;
          });
          break;
      }
    };
    cellEl.addEventListener('keyup', onKeyUp);
    return function () {
      cellEl.removeEventListener('keyup', onKeyUp);
    };
  }, [cellEl]);
  return (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    disabled: !isCellEntered,
    onDeactivation: function onDeactivation() {
      return setIsCellEntered(false);
    },
    clickOutsideDisables: true
  }, children, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, ' - ', (0, _react2.jsx)(_i18n.EuiI18n
  // eslint-disable-next-line local/i18n
  , {
    token: "euiDataGridCell.focusTrapEnterPrompt",
    default: "Press the Enter key to interact with this cell's contents."
  }))));
};

/**
 * Utility fns for managing child interactive tabIndex state
 */
exports.FocusTrappedChildren = FocusTrappedChildren;
FocusTrappedChildren.propTypes = {
  cellEl: _propTypes.default.any.isRequired
};
var disableInteractives = function disableInteractives(cell) {
  var interactives = (0, _tabbable.tabbable)(cell);
  interactives.forEach(function (element) {
    element.setAttribute('data-euigrid-tab-managed', 'true');
    element.setAttribute('tabIndex', '-1');
  });
  return interactives;
};
var enableAndFocusInteractives = function enableAndFocusInteractives(cell) {
  var interactives = cell.querySelectorAll('[data-euigrid-tab-managed]');
  interactives.forEach(function (element, i) {
    element.setAttribute('tabIndex', '0');
    if (i === 0) {
      element.focus();
    }
  });
  return interactives;
};