"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _sorting = require("../../utils/sorting");
var _data_grid_cell_popover = require("./data_grid_cell_popover");
var _data_grid_cell = require("./data_grid_cell");
var _react2 = require("@emotion/react");
var _excluded = ["colIndex", "visibleRowIndex", "style", "schema", "schemaDetectors", "pagination", "columns", "leadingControlColumns", "trailingControlColumns", "visibleColCount", "columnWidths", "defaultColumnWidth", "renderCellValue", "cellContext", "renderCellPopover", "interactiveCellId", "setRowHeight", "rowHeightsOptions", "rowHeightUtils", "rowManager"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
/**
 * A DRY wrapper used by both custom and virtualized grid cells.
 * It grabs context,  determines the type of cell being rendered
 * (e.g. control vs data cell), & sets shared props between all cells
 */
var CellWrapper = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var colIndex = _ref.colIndex,
    visibleRowIndex = _ref.visibleRowIndex,
    style = _ref.style,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    pagination = _ref.pagination,
    columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    visibleColCount = _ref.visibleColCount,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    renderCellPopover = _ref.renderCellPopover,
    interactiveCellId = _ref.interactiveCellId,
    setRowHeight = _ref.setRowHeight,
    rowHeightsOptions = _ref.rowHeightsOptions,
    rowHeightUtils = _ref.rowHeightUtils,
    rowManager = _ref.rowManager,
    rest = _objectWithoutProperties(_ref, _excluded);
  var popoverContext = (0, _react.useContext)(_data_grid_cell_popover.DataGridCellPopoverContext);
  var _useContext = (0, _react.useContext)(_sorting.DataGridSortedContext),
    getCorrectRowIndex = _useContext.getCorrectRowIndex;
  var isFirstColumn = colIndex === 0;
  var isLastColumn = colIndex === visibleColCount - 1;
  var isLeadingControlColumn = colIndex < leadingControlColumns.length;
  var isTrailingControlColumn = colIndex >= leadingControlColumns.length + columns.length;
  var datacolIndex = colIndex - leadingControlColumns.length;
  var column = columns[datacolIndex];
  var columnId = column === null || column === void 0 ? void 0 : column.id;
  var textTransform = (0, _react.useMemo)(function () {
    var _schemaDetectors$filt;
    return (_schemaDetectors$filt = schemaDetectors.filter(function (row) {
      return column !== null && column !== void 0 && column.schema ? (column === null || column === void 0 ? void 0 : column.schema) === row.type : columnId === row.type;
    })[0]) === null || _schemaDetectors$filt === void 0 ? void 0 : _schemaDetectors$filt.textTransform;
  }, [columnId, column === null || column === void 0 ? void 0 : column.schema, schemaDetectors]);
  var sharedCellProps = (0, _react.useMemo)(function () {
    var classes = (0, _classnames.default)(_defineProperty({
      'euiDataGridRowCell--firstColumn': isFirstColumn,
      'euiDataGridRowCell--lastColumn': isLastColumn,
      'euiDataGridRowCell--controlColumn': isLeadingControlColumn || isTrailingControlColumn
    }, "euiDataGridRowCell--".concat(textTransform), textTransform));
    return {
      rowIndex: getCorrectRowIndex(visibleRowIndex),
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      interactiveCellId: interactiveCellId,
      className: classes,
      style: style,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      setRowHeight: isFirstColumn ? setRowHeight : undefined,
      rowManager: rowManager,
      popoverContext: popoverContext,
      pagination: pagination,
      cellContext: cellContext
    };
  }, [colIndex, setRowHeight, visibleRowIndex, getCorrectRowIndex, interactiveCellId, style, rowHeightsOptions, rowHeightUtils, rowManager, popoverContext, pagination, cellContext, isFirstColumn, isLastColumn, isLeadingControlColumn, isTrailingControlColumn, textTransform]);
  if (isLeadingControlColumn) {
    var leadingColumn = leadingControlColumns[colIndex];
    var id = leadingColumn.id,
      rowCellRender = leadingColumn.rowCellRender;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: id,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      isExpandable: false
    }, rest));
  } else if (isTrailingControlColumn) {
    var columnOffset = columns.length + leadingControlColumns.length;
    var trailingcolIndex = colIndex - columnOffset;
    var trailingColumn = trailingControlColumns[trailingcolIndex];
    var _id = trailingColumn.id,
      _rowCellRender = trailingColumn.rowCellRender;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: _id,
      width: trailingColumn.width,
      renderCellValue: _rowCellRender,
      isExpandable: false
    }, rest));
  } else {
    // this is a normal data cell
    var columnType = schema[columnId] ? schema[columnId].columnType : null;
    var isExpandable = (column === null || column === void 0 ? void 0 : column.isExpandable) !== undefined ? column === null || column === void 0 ? void 0 : column.isExpandable : true;
    var width = columnWidths[columnId] || defaultColumnWidth;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: columnId,
      column: column,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      isExpandable: isExpandable
    }, rest));
  }
});
exports.CellWrapper = CellWrapper;
CellWrapper.displayName = 'CellWrapper';