"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxOptionAppendPrepend = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * DRY util for rendering an option with its prepend and append properties
 */
var EuiComboBoxOptionAppendPrepend = function EuiComboBoxOptionAppendPrepend(_ref) {
  var children = _ref.children,
    option = _ref.option,
    classNamePrefix = _ref.classNamePrefix;
  return (0, _react2.jsx)(_react.default.Fragment, null, (option === null || option === void 0 ? void 0 : option.prepend) && (0, _react2.jsx)("span", {
    className: "".concat(classNamePrefix, "__prepend")
  }, option.prepend), children, (option === null || option === void 0 ? void 0 : option.append) && (0, _react2.jsx)("span", {
    className: "".concat(classNamePrefix, "__append")
  }, option.append));
};
exports.EuiComboBoxOptionAppendPrepend = EuiComboBoxOptionAppendPrepend;