"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsibleNavSubItemsStyles = exports.euiCollapsibleNavItemVariables = exports.euiCollapsibleNavItemTitleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
/**
 * Style variables shared between accordion, link, and sub items
 */
var euiCollapsibleNavItemVariables = function euiCollapsibleNavItemVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return _objectSpread(_objectSpread({
    height: euiTheme.size.xl,
    padding: euiTheme.size.s
  }, (0, _global_styling.euiFontSize)(euiThemeContext, 's')), {}, {
    animation: "".concat(euiTheme.animation.normal, " ease-in-out"),
    // Matches EuiButton
    borderRadius: euiTheme.border.radius.small,
    backgroundHoverColor: euiTheme.colors.lightestShade,
    backgroundSelectedColor: (0, _button.euiButtonColor)(euiThemeContext, 'text').backgroundColor,
    color: euiTheme.colors.text,
    rightIconColor: euiTheme.colors.disabledText
  });
};

/**
 * Title styles
 */
exports.euiCollapsibleNavItemVariables = euiCollapsibleNavItemVariables;
var euiCollapsibleNavItemTitleStyles = {
  euiCollapsibleNavItem__title: process.env.NODE_ENV === "production" ? {
    name: "i246l1-euiCollapsibleNavItem__title",
    styles: "flex-grow:1;label:euiCollapsibleNavItem__title;"
  } : {
    name: "i246l1-euiCollapsibleNavItem__title",
    styles: "flex-grow:1;label:euiCollapsibleNavItem__title;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};

/**
 * Sub item groups
 */
exports.euiCollapsibleNavItemTitleStyles = euiCollapsibleNavItemTitleStyles;
var euiCollapsibleNavSubItemsStyles = function euiCollapsibleNavSubItemsStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCollapsibleNavItem__items: /*#__PURE__*/(0, _react.css)(";label:euiCollapsibleNavItem__items;"),
    isGroup: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), ";;label:isGroup;"),
    isTopItem: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.xl), ";;label:isTopItem;"),
    isSubItem: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin), " ", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('padding-left', (0, _global_styling.mathWithUnits)([euiTheme.size.s, euiTheme.border.width.thin], function (x, y) {
      return x - y;
    })), ";;label:isSubItem;")
  };
};
exports.euiCollapsibleNavSubItemsStyles = euiCollapsibleNavSubItemsStyles;