"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonGroupButton = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _button = require("../../../themes/amsterdam/global_styling/mixins/button");
var _inner_text = require("../../inner_text");
var _button_display = require("../button_display/_button_display");
var _button_group_button = require("./button_group_button.styles");
var _tool_tip = require("../../../components/tool_tip");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "isDisabled", "isIconOnly", "isSelected", "label", "value", "size", "color", "toolTipContent", "toolTipProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiButtonGroupButton = function EuiButtonGroupButton(_ref) {
  var className = _ref.className,
    id = _ref.id,
    isDisabled = _ref.isDisabled,
    isIconOnly = _ref.isIconOnly,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    label = _ref.label,
    value = _ref.value,
    size = _ref.size,
    _ref$color = _ref.color,
    _color = _ref$color === void 0 ? 'primary' : _ref$color,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isCompressed = size === 'compressed';
  var color = isDisabled ? 'disabled' : _color;
  var display = isSelected ? 'fill' : isCompressed ? 'empty' : 'base';
  var hasToolTip = !!toolTipContent;
  var styles = (0, _services.useEuiMemoizedStyles)(_button_group_button.euiButtonGroupButtonStyles);
  var focusColorStyles = (0, _services.useEuiMemoizedStyles)(_button_group_button._compressedButtonFocusColors);
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: display
  })[color];
  var cssStyles = [styles.euiButtonGroupButton, isIconOnly && styles.iconOnly, !isCompressed && (hasToolTip ? styles.uncompressed.hasToolTip : styles.uncompressed[size]), isCompressed ? styles.compressed : styles.uncompressed.uncompressed, isDisabled && isSelected ? styles.disabledAndSelected : buttonColorStyles, !isDisabled && isCompressed && focusColorStyles[color]];
  var tooltipWrapperStyles = [styles.tooltipWrapper, !isCompressed && styles.uncompressed[size]];
  var contentStyles = [styles.content.euiButtonGroupButton__content, isCompressed && styles.content.compressed];
  var textStyles = [isIconOnly ? styles.text.euiButtonGroupButton__iconOnly : styles.text.euiButtonGroupButton__text];
  var buttonClasses = (0, _classnames.default)('euiButtonGroupButton', {
    'euiButtonGroupButton-isSelected': isSelected,
    'euiButtonGroupButton-isIconOnly': isIconOnly
  }, className);

  /**
   * Because the selected buttons also increase their text weight to 'bold',
   * we don't want the whole button size to shift when selected, so we determine
   * the base width of the button via the `euiTextShift()` method in SASS.
   */
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    buttonTextRef = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return (0, _react2.jsx)(EuiButtonGroupButtonWithToolTip, {
    toolTipContent: toolTipContent,
    toolTipProps: toolTipProps,
    wrapperCss: tooltipWrapperStyles,
    isSelected: isSelected
  }, (0, _react2.jsx)(_button_display.EuiButtonDisplay, _extends({
    css: cssStyles,
    className: buttonClasses,
    isDisabled: isDisabled,
    size: size === 'compressed' ? 's' : size,
    contentProps: {
      css: contentStyles
    },
    textProps: {
      css: textStyles,
      ref: buttonTextRef,
      'data-text': innerText
    },
    title: innerText,
    "data-test-subj": id,
    isSelected: isSelected
  }, rest), label));
};
exports.EuiButtonGroupButton = EuiButtonGroupButton;
EuiButtonGroupButton.propTypes = {
  /**
     * Each option must have a unique `id` for maintaining selection
     */
  id: _propTypes.default.string.isRequired,
  /**
     * Each option must have a `label` even for icons which will be applied as the `aria-label`
     */
  label: _propTypes.default.node.isRequired,
  isDisabled: _propTypes.default.bool,
  /**
     * The value of the radio input.
     */
  value: _propTypes.default.any,
  /**
     * The type of the underlying HTML button
     */
  type: _propTypes.default.any,
  /**
     * By default, will use the button text for the native browser title.
     *
     * This can be either customized or unset via `title: ''` if necessary.
     */
  title: _propTypes.default.any,
  /**
     * Optional custom tooltip content for the button
     */
  toolTipContent: _propTypes.default.node,
  /**
     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
     */
  toolTipProps: _propTypes.default.any,
  /**
     * Any `type` accepted by EuiIcon
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
  /**
     * Can only be one side `left` or `right`
     */
  iconSide: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([undefined])]),
  isLoading: _propTypes.default.bool,
  /**
     * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
     *
     * This span wrapper can be removed by passing `textProps={false}`.
     */
  textProps: _propTypes.default.oneOfType([_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    ref: _propTypes.default.any,
    "data-text": _propTypes.default.string
  }).isRequired, _propTypes.default.oneOf([false])]),
  iconSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Styles the selected button to look selected (usually with `fill`)
     */
  isSelected: _propTypes.default.bool,
  /**
     * Inherit from EuiButtonGroup
     */
  color: _propTypes.default.any.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  size: _propTypes.default.any.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  isIconOnly: _propTypes.default.bool.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  onClick: _propTypes.default.func.isRequired
};
var EuiButtonGroupButtonWithToolTip = function EuiButtonGroupButtonWithToolTip(_ref2) {
  var _toolTipProps$anchorP, _toolTipProps$anchorP2;
  var toolTipContent = _ref2.toolTipContent,
    toolTipProps = _ref2.toolTipProps,
    wrapperCss = _ref2.wrapperCss,
    isSelected = _ref2.isSelected,
    children = _ref2.children;
  return toolTipContent ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({
    content: toolTipContent,
    position: "top"
  }, toolTipProps, {
    anchorProps: _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorProps), {}, {
      className: (0, _classnames.default)('euiButtonGroup__tooltipWrapper', {
        'euiButtonGroup__tooltipWrapper-isSelected': isSelected
      }, toolTipProps === null || toolTipProps === void 0 ? void 0 : (_toolTipProps$anchorP = toolTipProps.anchorProps) === null || _toolTipProps$anchorP === void 0 ? void 0 : _toolTipProps$anchorP.className),
      css: [wrapperCss, toolTipProps === null || toolTipProps === void 0 ? void 0 : (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.css]
    })
  }), children) : children;
};
EuiButtonGroupButtonWithToolTip.propTypes = {
  children: _propTypes.default.element.isRequired,
  wrapperCss: _propTypes.default.any.isRequired,
  isSelected: _propTypes.default.bool.isRequired
};