"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBreadcrumbStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
/**
 * Styles cast to <li> element
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1k7t4ns-isCollapsed",
  styles: "flex-shrink:0;label:isCollapsed;"
} : {
  name: "1k7t4ns-isCollapsed",
  styles: "flex-shrink:0;label:isCollapsed;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "p0bcva-isTruncated",
  styles: "overflow:hidden;label:isTruncated;"
} : {
  name: "p0bcva-isTruncated",
  styles: "overflow:hidden;label:isTruncated;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBreadcrumbStyles = function euiBreadcrumbStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiBreadcrumb: /*#__PURE__*/(0, _react.css)("align-items:center;display:flex;", (0, _global_styling.logicalCSS)(
    // See .euiBreadcrumbs__list's negative margin-bottom
    'margin-bottom', euiTheme.size.xs), ";;label:euiBreadcrumb;"),
    isTruncated: _ref2,
    isCollapsed: _ref,
    // Types
    page: /*#__PURE__*/(0, _react.css)("&:not(:last-of-type){&::after{background:", euiTheme.colors.lightShade, ";content:'';flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', 0), " ", (0, _global_styling.logicalCSS)('margin-horizontal', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('height', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('width', '1px'), " transform:translateY(-1px) rotate(15deg);}};label:page;"),
    application: /*#__PURE__*/(0, _react.css)("&:not(:last-of-type){", (0, _global_styling.logicalCSS)('margin-right', "-".concat(euiTheme.size.xs)), ";};label:application;")
  };
};
exports.euiBreadcrumbStyles = euiBreadcrumbStyles;