"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbCollapsed = exports.EuiBreadcrumb = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _breadcrumb_content = require("./_breadcrumb_content");
var _breadcrumb = require("./breadcrumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "type", "truncate"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiBreadcrumb', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return (0, _react2.jsx)("li", _extends({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
exports.EuiBreadcrumb = EuiBreadcrumb;
var EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref2) {
  var children = _ref2.children,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    type = _ref2.type;
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  return (0, _react2.jsx)(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, (0, _react2.jsx)(_breadcrumb_content.EuiBreadcrumbContent, {
    popoverContent: children,
    text: (0, _react2.jsx)("span", {
      "aria-label": ariaLabel
    }, "\u2026"),
    title: ariaLabel,
    truncate: false,
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  }));
};
exports.EuiBreadcrumbCollapsed = EuiBreadcrumbCollapsed;