"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _link = require("../link");
var _popover = require("../popover");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _breadcrumb_content = require("./_breadcrumb_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["text", "truncate", "type", "href", "rel", "onClick", "popoverContent", "popoverProps", "className", "color", "isFirstBreadcrumb", "isLastBreadcrumb", "isOnlyBreadcrumb", "highlightLastBreadcrumb", "truncateLastBreadcrumb"],
  _excluded2 = ["css"],
  _excluded3 = ["popoverContent", "popoverProps", "color", "type", "title", "aria-current", "className", "isLastBreadcrumb", "breadcrumbCss", "truncationCss", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiBreadcrumbContent = function EuiBreadcrumbContent(_ref) {
  var text = _ref.text,
    truncate = _ref.truncate,
    type = _ref.type,
    href = _ref.href,
    rel = _ref.rel,
    onClick = _ref.onClick,
    popoverContent = _ref.popoverContent,
    popoverProps = _ref.popoverProps,
    className = _ref.className,
    color = _ref.color,
    isFirstBreadcrumb = _ref.isFirstBreadcrumb,
    isLastBreadcrumb = _ref.isLastBreadcrumb,
    isOnlyBreadcrumb = _ref.isOnlyBreadcrumb,
    highlightLastBreadcrumb = _ref.highlightLastBreadcrumb,
    truncateLastBreadcrumb = _ref.truncateLastBreadcrumb,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isApplication = type === 'application';
  var classes = (0, _classnames.default)('euiBreadcrumb__content', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb_content.euiBreadcrumbContentStyles);
  var cssStyles = [styles.euiBreadcrumb__content, styles[type]];
  if (isApplication) {
    if (isOnlyBreadcrumb) {
      cssStyles.push(styles.applicationStyles.onlyChild);
    } else if (isFirstBreadcrumb) {
      cssStyles.push(styles.applicationStyles.firstChild);
    } else if (isLastBreadcrumb) {
      cssStyles.push(styles.applicationStyles.lastChild);
    }
  }
  var truncationStyles = [truncate && !truncateLastBreadcrumb && styles.isTruncated, truncateLastBreadcrumb && styles.isTruncatedLast];
  var isBreadcrumbWithPopover = !!popoverContent;
  var isInteractiveBreadcrumb = href || onClick;
  var linkColor = color || 'subdued';
  var ariaCurrent = highlightLastBreadcrumb ? 'page' : undefined;
  var interactionStyles = (isInteractiveBreadcrumb || isBreadcrumbWithPopover) && !isApplication && styles.isInteractive;
  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    var title = innerText === '' ? undefined : innerText;
    var baseProps = {
      ref: ref,
      title: title,
      'aria-current': ariaCurrent,
      className: classes,
      css: [].concat(cssStyles, truncationStyles, [interactionStyles])
    };
    if (isBreadcrumbWithPopover) {
      var _ = baseProps.css,
        popoverButtonProps = _objectWithoutProperties(baseProps, _excluded2);
      return (0, _react2.jsx)(EuiBreadcrumbPopover, _extends({}, popoverButtonProps, {
        breadcrumbCss: [].concat(cssStyles, [interactionStyles]),
        truncationCss: truncationStyles,
        isLastBreadcrumb: isLastBreadcrumb,
        type: type,
        color: linkColor,
        popoverContent: popoverContent,
        popoverProps: popoverProps
      }, rest), text);
    } else if (isInteractiveBreadcrumb) {
      return (0, _react2.jsx)(_link.EuiLink, _extends({}, baseProps, {
        color: linkColor,
        onClick: onClick,
        href: href,
        rel: rel
      }, rest), text);
    } else {
      return (0, _react2.jsx)("span", _extends({}, baseProps, rest), text);
    }
  });
};
exports.EuiBreadcrumbContent = EuiBreadcrumbContent;
EuiBreadcrumbContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  href: _propTypes.default.string,
  rel: _propTypes.default.string,
  onClick: _propTypes.default.func,
  /**
       * Visible label of the breadcrumb
       */
  text: _propTypes.default.node.isRequired,
  /**
       * Force a max-width on the breadcrumb text
       */
  truncate: _propTypes.default.bool,
  /**
       * @deprecated - if a custom color is wanted, use the `css` prop to pass custom css
       */
  color: _propTypes.default.any,
  /**
       * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
       */
  "aria-current": _propTypes.default.any,
  /**
       * Creates a breadcrumb that toggles a popover dialog. Takes any rendered node(s),
       * or a render function that will pass callback allowing you to close the
       * breadcrumb popover from within your popover content.
       *
       * If passed, both `href` and `onClick` will be ignored - the breadcrumb's
       * click behavior should only trigger a popover.
       */
  popoverContent: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]),
  /**
       * Allows customizing the popover if necessary. Accepts any props that
       * [EuiPopover](/#/layout/popover) accepts, except for props that control state.
       */
  popoverProps: _propTypes.default.shape({
    /**
       * Alignment of the popover and arrow relative to the button
       */
    anchorPosition: _propTypes.default.any,
    /**
       * Style and position alteration for arrow-less attachment.
       * Intended for use with inputs as anchors, e.g. EuiInputPopover
       */
    attachToAnchor: _propTypes.default.bool,
    /**
       * Restrict the popover's position within this element
       */
    container: _propTypes.default.any,
    /**
       * CSS display type for both the popover and anchor
       */
    display: _propTypes.default.any,
    /**
       * Object of props passed to EuiFocusTrap
       */
    focusTrapProps: _propTypes.default.any,
    /**
       * Show arrow indicating to originating button
       */
    hasArrow: _propTypes.default.bool,
    /**
       * Specifies what element should initially have focus; Can be a DOM
       * node, or a selector string (which will be passed to
       * document.querySelector() to find the DOM node), or a function that
       * returns a DOM node.
       *
       * If not passed, initial focus defaults to the popover panel.
       */
    initialFocus: _propTypes.default.any,
    /**
       * Passed directly to EuiPortal for DOM positioning. Both properties are
       * required if prop is specified
       */
    insert: _propTypes.default.shape({
      sibling: _propTypes.default.any.isRequired,
      position: _propTypes.default.oneOf(["before", "after"]).isRequired
    }),
    /**
       * Traps tab focus within the popover contents
       */
    ownFocus: _propTypes.default.bool,
    /**
       * Custom class added to the EuiPanel containing the popover contents
       */
    panelClassName: _propTypes.default.string,
    /**
       * EuiPanel padding on all sides
       */
    panelPaddingSize: _propTypes.default.any,
    /**
       * Standard DOM `style` attribute. Passed to the EuiPanel
       */
    panelStyle: _propTypes.default.any,
    /**
       * Object of props passed to EuiPanel. See #EuiPopoverPanelProps
       */
    panelProps: _propTypes.default.shape({
      element: _propTypes.default.oneOf(["div"]),
      /**
         * Padding for all four sides
         */
      paddingSize: _propTypes.default.any,
      /**
         * Corner border radius
         */
      borderRadius: _propTypes.default.any,
      /**
         * When true the panel will grow in height to match `EuiFlexItem`
         */
      grow: _propTypes.default.bool,
      panelRef: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }),
    panelRef: _propTypes.default.any,
    /**
       * Optional screen reader instructions to announce upon popover open,
       * in addition to EUI's default popover instructions for Escape on close.
       * Useful for popovers that may have additional keyboard capabilities such as
       * arrow navigation.
       */
    popoverScreenReaderText: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),
    popoverRef: _propTypes.default.any,
    /**
       * When `true`, the popover's position is re-calculated when the user
       * scrolls, this supports having fixed-position popover anchors. When nesting
       * an `EuiPopover` in a scrollable container, `repositionOnScroll` should be `true`
       */
    repositionOnScroll: _propTypes.default.bool,
    /**
       * By default, popovers will attempt to position themselves along the initial
       * axis specified. If there is not enough room either vertically or horizontally
       * however, the popover will attempt to reposition itself along the secondary
       * cross axis if there is room there instead.
       *
       * If you do not not want this repositioning to occur (and it is acceptable for
       * the popover to appear offscreen), set this to false to disable this behavior.
       *
       * @default true
       */
    repositionToCrossAxis: _propTypes.default.bool,
    /**
       * Must be set to true if using `EuiDragDropContext` within a popover,
       * otherwise your nested drag & drop will have incorrect positioning
       */
    hasDragDrop: _propTypes.default.bool,
    /**
       * By default, popover content inherits the z-index of the anchor
       * component; pass `zIndex` to override
       */
    zIndex: _propTypes.default.number,
    /**
       * Distance away from the anchor that the popover will render
       */
    offset: _propTypes.default.number,
    /**
       * Minimum distance between the popover and the bounding container;
       * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
       * Default is 16
       */
    buffer: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.any.isRequired]),
    /**
       * Element to pass as the child element of the arrow;
       * Use case is typically limited to an accompanying `EuiBeacon`
       */
    arrowChildren: _propTypes.default.node,
    /**
       * Provide a name to the popover panel
       */
    "aria-label": _propTypes.default.string,
    /**
       * Alternative option to `aria-label` that takes an `id`.
       * Usually takes the `id` of the popover title
       */
    "aria-labelledby": _propTypes.default.string,
    /**
       * Function callback for when the popover positon changes
       */
    onPositionChange: _propTypes.default.func,
    className: _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  type: _propTypes.default.any.isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};
var EuiBreadcrumbPopover = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var popoverContent = _ref2.popoverContent,
    popoverProps = _ref2.popoverProps,
    color = _ref2.color,
    type = _ref2.type,
    title = _ref2.title,
    ariaCurrent = _ref2['aria-current'],
    className = _ref2.className,
    isLastBreadcrumb = _ref2.isLastBreadcrumb,
    breadcrumbCss = _ref2.breadcrumbCss,
    truncationCss = _ref2.truncationCss,
    children = _ref2.children,
    rest = _objectWithoutProperties(_ref2, _excluded3);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(false);
  }, []);
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var popoverAriaLabel = (0, _i18n.useEuiI18n)(
  // This component was moved into another file for organization/dev readability,
  // but we're keeping the i18n token the same as before for consumer consistency
  // eslint-disable-next-line local/i18n
  'euiBreadcrumb.popoverAriaLabel', 'Clicking this button will toggle a popover dialog.');
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb_content.euiBreadcrumbPopoverStyles);
  var wrapperStyles = [styles.popoverWrapper.euiBreadcrumb__popoverWrapper, !isLastBreadcrumb && styles.popoverWrapper[type]];
  var buttonStyles = [styles.euiBreadcrumb__popoverButton].concat(_toConsumableArray(breadcrumbCss));
  var truncationStyles = [styles.euiBreadcrumb__popoverTruncation].concat(_toConsumableArray(truncationCss));
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({}, popoverProps, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    css: wrapperStyles,
    button: (0, _react2.jsx)(_link.EuiLink, _extends({
      ref: ref,
      title: title,
      "aria-current": ariaCurrent,
      className: className,
      css: buttonStyles,
      color: color,
      onClick: togglePopover
    }, rest), (0, _react2.jsx)("span", {
      css: truncationStyles
    }, children), (0, _react2.jsx)(_icon.EuiIcon, {
      type: "arrowDown",
      size: "s",
      "aria-label": " - ".concat(popoverAriaLabel)
    }))
  }), typeof popoverContent === 'function' ? popoverContent(closePopover) : popoverContent);
});
EuiBreadcrumbPopover.propTypes = {
  breadcrumbCss: _propTypes.default.any.isRequired,
  truncationCss: _propTypes.default.any.isRequired
};
EuiBreadcrumbPopover.displayName = 'EuiBreadcrumbPopover';