"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInMemoryTable = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("./basic_table");
var _predicate = require("../../services/predicate");
var _sort2 = require("../../services/sort");
var _search_bar = require("../search_bar/search_bar");
var _search_box = require("../search_bar/search_box");
var _spacer = require("../spacer");
var _table_pagination = require("../table/table_pagination");
var _component_defaults = require("../provider/component_defaults");
var _react2 = require("@emotion/react");
var _excluded = ["schema"],
  _excluded2 = ["onChange"],
  _excluded3 = ["columns", "loading", "message", "error", "selection", "isSelectable", "hasActions", "compressed", "pagination", "sorting", "itemIdToExpandedRowMap", "itemId", "rowProps", "cellProps", "tableLayout", "items", "search", "searchFormat", "onTableChange", "executeQueryOptions", "allowNeutralSort", "childrenBetween"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
function isEuiSearchBarProps(x) {
  return typeof x !== 'boolean';
}
var getQueryFromSearch = function getQueryFromSearch(search, defaultQuery) {
  var query;
  if (!search) {
    query = '';
  } else {
    query = (defaultQuery ? search.defaultQuery || search.query || '' : search.query) || '';
  }
  return (0, _predicate.isString)(query) ? _search_bar.EuiSearchBar.Query.parse(query) : query;
};
var getInitialPagination = function getInitialPagination(pagination, consumerDefaults) {
  var _ref2, _pagination$pageIndex, _ref3, _pagination$pageSize;
  if (!pagination) {
    return {
      pageIndex: undefined,
      pageSize: undefined
    };
  }
  var defaults = _objectSpread(_objectSpread({}, _table_pagination.euiTablePaginationDefaults), consumerDefaults);
  var _ref = pagination,
    _ref$pageSizeOptions = _ref.pageSizeOptions,
    pageSizeOptions = _ref$pageSizeOptions === void 0 ? defaults.itemsPerPageOptions : _ref$pageSizeOptions,
    _ref$showPerPageOptio = _ref.showPerPageOptions,
    showPerPageOptions = _ref$showPerPageOptio === void 0 ? defaults.showPerPageOptions : _ref$showPerPageOptio;
  var defaultPageSize = pageSizeOptions !== null && pageSizeOptions !== void 0 && pageSizeOptions.includes(defaults.itemsPerPage) ? defaults.itemsPerPage : pageSizeOptions[0];
  var initialPageIndex = pagination === true ? 0 : (_ref2 = (_pagination$pageIndex = pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : pagination.initialPageIndex) !== null && _ref2 !== void 0 ? _ref2 : 0;
  var initialPageSize = pagination === true ? defaultPageSize : (_ref3 = (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : pagination.initialPageSize) !== null && _ref3 !== void 0 ? _ref3 : defaultPageSize;
  if (showPerPageOptions && initialPageSize != null && !(pageSizeOptions !== null && pageSizeOptions !== void 0 && pageSizeOptions.includes(initialPageSize))) {
    throw new Error("EuiInMemoryTable received initialPageSize ".concat(initialPageSize, ", which wasn't provided within pageSizeOptions."));
  }
  return {
    pageIndex: initialPageIndex,
    pageSize: initialPageSize,
    pageSizeOptions: pageSizeOptions,
    showPerPageOptions: showPerPageOptions
  };
};
function findColumnByProp(columns, prop, value) {
  for (var i = 0; i < columns.length; i++) {
    var column = columns[i];
    if (column[prop] === value) {
      return column;
    }
  }
}
function findColumnByFieldOrName(columns, value) {
  // The passed value can be a column's `field` or its `name`
  // for backwards compatibility `field` must be checked first
  var column = findColumnByProp(columns, 'field', value);
  if (column == null) {
    column = findColumnByProp(columns, 'name', value);
  }
  return column;
}
function getInitialSorting(columns, sorting) {
  if (!sorting || !sorting.sort) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }
  var _sort = sorting.sort,
    sortable = _sort.field,
    sortDirection = _sort.direction;
  var sortColumn = findColumnByFieldOrName(columns, sortable);
  if (sortColumn == null) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }
  var sortName = sortColumn.name;
  return {
    sortName: sortName,
    sortDirection: sortDirection
  };
}
var EuiInMemoryTable = /*#__PURE__*/function (_Component) {
  _inherits(EuiInMemoryTable, _Component);
  var _super = _createSuper(EuiInMemoryTable);
  function EuiInMemoryTable(props, context) {
    var _this;
    _classCallCheck(this, EuiInMemoryTable);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "onTableChange", function (_ref4) {
      var page = _ref4.page,
        sort = _ref4.sort;
      var _ref5 = page || {},
        pageIndex = _ref5.index,
        pageSize = _ref5.size;

      // don't apply pagination changes that are otherwise controlled
      // `page` is left unchanged as it goes to the consumer's `onTableChange` callback, allowing the app to respond
      var pagination = _this.props.pagination;
      if (pagination != null && typeof pagination !== 'boolean') {
        if (pagination.pageSize != null) pageSize = pagination.pageSize;
        if (pagination.pageIndex != null) pageIndex = pagination.pageIndex;
      }
      var _ref6 = sort || {},
        sortName = _ref6.field,
        sortDirection = _ref6.direction;

      // To keep backwards compatibility reportedSortName needs to be tracked separately
      // from sortName; sortName gets stored internally while reportedSortName is sent to the callback
      var reportedSortName = sortName;

      // EuiBasicTable returns the column's `field` instead of `name` on sort
      // and the column's `name` instead of `field` on pagination
      if (sortName) {
        var sortColumn = findColumnByFieldOrName(_this.props.columns, sortName);
        if (sortColumn) {
          // Ensure sortName uses `name`
          sortName = sortColumn.name;

          // Ensure reportedSortName uses `field` if it exists
          var sortField = sortColumn.field;
          if (sortField) reportedSortName = sortField;
        }
      }

      // Allow going back to 'neutral' sorting
      if (_this.state.allowNeutralSort && _this.state.sortName === sortName && _this.state.sortDirection === 'desc' && sortDirection === 'asc') {
        sortName = '';
        reportedSortName = '';
        sortDirection = 'asc'; // Default sort direction.
      }

      if (_this.props.onTableChange) {
        _this.props.onTableChange({
          // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
          page: page,
          sort: {
            field: reportedSortName,
            direction: sortDirection
          }
        });
      }
      _this.setState({
        pageIndex: pageIndex,
        pageSize: pageSize,
        sortName: sortName,
        sortDirection: sortDirection
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onQueryChange", function (_ref7) {
      var query = _ref7.query,
        queryText = _ref7.queryText,
        error = _ref7.error;
      var search = _this.props.search;
      if (isEuiSearchBarProps(search)) {
        if (search.onChange) {
          var shouldQueryInMemory = error == null ? search.onChange({
            query: query,
            queryText: queryText,
            error: null
          }) : search.onChange({
            query: null,
            queryText: queryText,
            error: error
          });
          if (!shouldQueryInMemory) {
            return;
          }
        }
      }

      // Reset pagination state.
      _this.setState(function (state) {
        return {
          prevProps: _objectSpread(_objectSpread({}, state.prevProps), {}, {
            search: search
          }),
          query: query,
          pageIndex: 0
        };
      });
    });
    // Alternative to onQueryChange - allows consumers to specify they want the
    // search bar to ignore EQL syntax and only use the searchbar for plain text
    _defineProperty(_assertThisInitialized(_this), "onPlainTextSearch", function (searchValue) {
      var escapedQueryText = searchValue.replace(/["\\]/g, '\\$&');
      var finalQuery = "\"".concat(escapedQueryText, "\"");
      _this.setState({
        query: _search_bar.EuiSearchBar.Query.parse(finalQuery)
      });
    });
    var columns = props.columns,
      _search = props.search,
      _pagination = props.pagination,
      sorting = props.sorting,
      allowNeutralSort = props.allowNeutralSort;
    var _getInitialPagination = getInitialPagination(_pagination, context.EuiTablePagination),
      _pageIndex = _getInitialPagination.pageIndex,
      _pageSize = _getInitialPagination.pageSize,
      pageSizeOptions = _getInitialPagination.pageSizeOptions,
      showPerPageOptions = _getInitialPagination.showPerPageOptions;
    var _getInitialSorting = getInitialSorting(columns, sorting),
      _sortName = _getInitialSorting.sortName,
      _sortDirection = _getInitialSorting.sortDirection;
    _this.state = {
      prevProps: {
        items: props.items,
        sortName: _sortName,
        sortDirection: _sortDirection,
        search: _search
      },
      search: _search,
      query: getQueryFromSearch(_search, true),
      pageIndex: _pageIndex || 0,
      pageSize: _pageSize,
      pageSizeOptions: pageSizeOptions,
      sortName: _sortName,
      sortDirection: _sortDirection,
      allowNeutralSort: allowNeutralSort !== false,
      showPerPageOptions: showPerPageOptions
    };
    return _this;
  }
  _createClass(EuiInMemoryTable, [{
    key: "renderSearchBar",
    value: function renderSearchBar() {
      var _this$props = this.props,
        search = _this$props.search,
        searchFormat = _this$props.searchFormat;
      if (!search) return;
      var searchBar;
      if (searchFormat === 'text') {
        var _searchBoxProps = (search === null || search === void 0 ? void 0 : search.box) || {}; // Work around | boolean type
        var schema = _searchBoxProps.schema,
          searchBoxProps = _objectWithoutProperties(_searchBoxProps, _excluded); // Destructure `schema` so it doesn't get rendered to DOM

        searchBar = (0, _react2.jsx)(_search_box.EuiSearchBox, _extends({
          query: "" // Unused, passed to satisfy Typescript
        }, searchBoxProps, {
          onSearch: this.onPlainTextSearch
        }));
      } else {
        var searchBarProps = {};
        if (isEuiSearchBarProps(search)) {
          var onChange = search.onChange,
            _searchBarProps = _objectWithoutProperties(search, _excluded2);
          searchBarProps = _searchBarProps;
          if (searchBarProps.box && searchBarProps.box.schema === true) {
            searchBarProps.box = _objectSpread(_objectSpread({}, searchBarProps.box), {}, {
              schema: this.resolveSearchSchema()
            });
          }
        }
        searchBar = (0, _react2.jsx)(_search_bar.EuiSearchBar, _extends({
          onChange: this.onQueryChange
        }, searchBarProps));
      }
      return (0, _react2.jsx)(_react.default.Fragment, null, searchBar, (0, _react2.jsx)(_spacer.EuiSpacer, {
        size: "l"
      }));
    }
  }, {
    key: "resolveSearchSchema",
    value: function resolveSearchSchema() {
      var columns = this.props.columns;
      return columns.reduce(function (schema, column) {
        var _ref8 = column,
          field = _ref8.field,
          dataType = _ref8.dataType;
        if (field) {
          var type = dataType || 'string';
          schema.fields[field] = {
            type: type
          };
        }
        return schema;
      }, {
        strict: true,
        fields: {}
      });
    }
  }, {
    key: "getItemSorter",
    value: function getItemSorter() {
      var _this$state = this.state,
        sortName = _this$state.sortName,
        sortDirection = _this$state.sortDirection;
      var columns = this.props.columns;
      var sortColumn = columns.find(function (_ref9) {
        var name = _ref9.name;
        return name === sortName;
      });
      if (sortColumn == null) {
        // can't return a non-function so return a function that says everything is the same
        return function () {
          return 0;
        };
      }
      var sortable = sortColumn.sortable;
      if (typeof sortable === 'function') {
        return _sort2.Comparators.value(sortable, _sort2.Comparators.default(sortDirection));
      }
      return _sort2.Comparators.property(sortColumn.field, _sort2.Comparators.default(sortDirection));
    }
  }, {
    key: "getItems",
    value: function getItems() {
      var executeQueryOptions = this.props.executeQueryOptions;
      var items = this.state.prevProps.items;
      if (!items.length) {
        return {
          items: [],
          totalItemCount: 0
        };
      }
      var _this$state2 = this.state,
        query = _this$state2.query,
        sortName = _this$state2.sortName,
        pageIndex = _this$state2.pageIndex,
        pageSize = _this$state2.pageSize;
      var matchingItems = query !== null && (executeQueryOptions === null || executeQueryOptions === void 0 ? void 0 : executeQueryOptions.enabled) !== false ? _search_bar.EuiSearchBar.Query.execute(query, items, executeQueryOptions) : items;
      var sortedItems = sortName ? matchingItems.slice(0) // avoid mutating the source array
      .sort(this.getItemSorter()) // sort, causes mutation
      : matchingItems;
      var visibleItems = pageSize && this.props.pagination ? function () {
        var startIndex = pageIndex * pageSize;
        return sortedItems.slice(startIndex, Math.min(startIndex + pageSize, sortedItems.length));
      }() : sortedItems;
      return {
        items: visibleItems,
        totalItemCount: matchingItems.length
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        columns = _this$props2.columns,
        loading = _this$props2.loading,
        message = _this$props2.message,
        error = _this$props2.error,
        selection = _this$props2.selection,
        isSelectable = _this$props2.isSelectable,
        hasActions = _this$props2.hasActions,
        compressed = _this$props2.compressed,
        hasPagination = _this$props2.pagination,
        hasSorting = _this$props2.sorting,
        itemIdToExpandedRowMap = _this$props2.itemIdToExpandedRowMap,
        itemId = _this$props2.itemId,
        rowProps = _this$props2.rowProps,
        cellProps = _this$props2.cellProps,
        tableLayout = _this$props2.tableLayout,
        _unuseditems = _this$props2.items,
        search = _this$props2.search,
        searchFormat = _this$props2.searchFormat,
        onTableChange = _this$props2.onTableChange,
        executeQueryOptions = _this$props2.executeQueryOptions,
        allowNeutralSort = _this$props2.allowNeutralSort,
        childrenBetween = _this$props2.childrenBetween,
        rest = _objectWithoutProperties(_this$props2, _excluded3);
      var _this$state3 = this.state,
        pageIndex = _this$state3.pageIndex,
        pageSize = _this$state3.pageSize,
        pageSizeOptions = _this$state3.pageSizeOptions,
        sortName = _this$state3.sortName,
        sortDirection = _this$state3.sortDirection,
        showPerPageOptions = _this$state3.showPerPageOptions;
      var _this$getItems = this.getItems(),
        items = _this$getItems.items,
        totalItemCount = _this$getItems.totalItemCount;
      var pagination = !hasPagination ? undefined : {
        pageIndex: pageIndex,
        pageSize: pageSize !== null && pageSize !== void 0 ? pageSize : 1,
        pageSizeOptions: pageSizeOptions,
        totalItemCount: totalItemCount,
        showPerPageOptions: showPerPageOptions
      };

      // Data loaded from a server can have a default sort order which is meaningful to the
      // user, but can't be reproduced with client-side sort logic. So we allow the table to display
      // rows in the order in which they're initially loaded by providing an undefined sorting prop.
      var sorting = !hasSorting ? undefined : {
        sort: !sortName && !sortDirection ? undefined : {
          field: sortName,
          direction: sortDirection
        },
        allowNeutralSort: this.state.allowNeutralSort
      };
      var searchBar = this.renderSearchBar();
      var table =
      // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
      (0, _react2.jsx)(_basic_table.EuiBasicTable, _extends({
        items: items,
        itemId: itemId,
        rowProps: rowProps,
        cellProps: cellProps,
        columns: columns,
        pagination: pagination,
        sorting: sorting,
        selection: selection,
        isSelectable: isSelectable,
        hasActions: hasActions,
        onChange: this.onTableChange,
        error: error,
        loading: loading,
        noItemsMessage: message,
        tableLayout: tableLayout,
        compressed: compressed,
        itemIdToExpandedRowMap: itemIdToExpandedRowMap
      }, rest));
      if (!searchBar) {
        return table;
      }
      return (0, _react2.jsx)("div", null, searchBar, childrenBetween, table);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var updatedPrevState = prevState;
      if (nextProps.items !== prevState.prevProps.items) {
        // We have new items because an external search has completed, so reset pagination state.

        var nextPageIndex = 0;
        if (nextProps.pagination != null && typeof nextProps.pagination !== 'boolean') {
          nextPageIndex = nextProps.pagination.pageIndex || 0;
        }
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            items: nextProps.items
          }),
          pageIndex: nextPageIndex
        });
      }

      // apply changes to controlled pagination
      if (nextProps.pagination != null && typeof nextProps.pagination !== 'boolean') {
        if (nextProps.pagination.pageSize != null && nextProps.pagination.pageSize !== updatedPrevState.pageIndex) {
          updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
            pageSize: nextProps.pagination.pageSize
          });
        }
        if (nextProps.pagination.pageIndex != null && nextProps.pagination.pageIndex !== updatedPrevState.pageIndex) {
          updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
            pageIndex: nextProps.pagination.pageIndex
          });
        }
      }
      var _getInitialSorting2 = getInitialSorting(nextProps.columns, nextProps.sorting),
        sortName = _getInitialSorting2.sortName,
        sortDirection = _getInitialSorting2.sortDirection;
      if (sortName !== prevState.prevProps.sortName || sortDirection !== prevState.prevProps.sortDirection) {
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            sortName: sortName,
            sortDirection: sortDirection
          }),
          sortName: sortName,
          sortDirection: sortDirection
        });
      }
      var nextQuery = nextProps.search ? nextProps.search.query : '';
      var prevQuery = prevState.prevProps.search ? prevState.prevProps.search.query : '';
      if (nextQuery !== prevQuery) {
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            search: nextProps.search
          }),
          query: getQueryFromSearch(nextProps.search, false)
        });
      }
      if (updatedPrevState !== prevState) {
        return updatedPrevState;
      }
      return null;
    }
  }]);
  return EuiInMemoryTable;
}(_react.Component);
exports.EuiInMemoryTable = EuiInMemoryTable;
_defineProperty(EuiInMemoryTable, "contextType", _component_defaults.EuiComponentDefaultsContext);
_defineProperty(EuiInMemoryTable, "defaultProps", {
  responsive: true,
  tableLayout: 'fixed',
  searchFormat: 'eql'
});
EuiInMemoryTable.propTypes = {
  className: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "aria-label": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]), _propTypes.default.string]),
  css: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.any]), _propTypes.default.any]),
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  itemId: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.func.isRequired]),
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  itemIdToExpandedRowMap: _propTypes.default.shape({}),
  /**
     * A list of objects to appear in the table - an item per row
     */
  /**
     * A list of objects to appear in the table - an item per row
     */
  items: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  /**
     * Applied to `EuiTableRowCell`
     */
  /**
     * Applied to `EuiTableRowCell`
     */
  cellProps: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
  /**
     * An array of one of the objects: #EuiTableFieldDataColumnType, #EuiTableComputedColumnType or #EuiTableActionsColumnType.
     */
  /**
     * An array of one of the objects: #EuiTableFieldDataColumnType, #EuiTableComputedColumnType or #EuiTableActionsColumnType.
     */
  columns: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    /**
       * A field of the item (may be a nested field)
       */
    // type hack used for better autocomplete support
    // https://github.com/microsoft/TypeScript/issues/29729
    field: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    // supports outer.inner key paths
    /**
       * The display name of the column
       */
    name: _propTypes.default.node.isRequired,
    /**
       * A description of the column (will be presented as a title over the column header)
       */
    description: _propTypes.default.string,
    /**
       * Describes the data types of the displayed value (serves as a rendering hint for the table)
       */
    dataType: _propTypes.default.oneOf(["auto", "string", "number", "boolean", "date"]),
    /**
       * A CSS width property. Hints for the required width of the column (e.g. "30%", "100px", etc..)
       */
    width: _propTypes.default.string,
    /**
       * Defines whether the user can sort on this column. If a function is provided, this function returns the value to sort against
       */
    sortable: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.func.isRequired]),
    isExpander: _propTypes.default.bool,
    /**
       * Creates a text wrapper around cell content that helps word break or truncate
       * long text correctly.
       */
    textOnly: _propTypes.default.bool,
    /**
       * Defines the horizontal alignment of the column
       */
    align: _propTypes.default.any,
    /**
       * Indicates whether this column should truncate overflowing text content.
       * - Set to `true` to enable single-line truncation.
       * - To enable multi-line truncation, use a configuration object with `lines`
       * set to a number of lines to truncate to.
       */
    truncateText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
      lines: _propTypes.default.number.isRequired
    }).isRequired]),
    mobileOptions: _propTypes.default.shape({
      render: _propTypes.default.func
    }),
    /**
       * Describe a custom renderer function for the content
       */
    render: _propTypes.default.func,
    /**
       * Content to display in the footer beneath this column
       */
    footer: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired, _propTypes.default.func.isRequired]),
    /**
       * Disables the user's ability to change the sort but still shows the current direction
       */
    readOnly: _propTypes.default.bool,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired, _propTypes.default.shape({
    /**
       * A function that computes the value for each item and renders it
       */
    render: _propTypes.default.func.isRequired,
    /**
       * The display name of the column
       */
    name: _propTypes.default.node,
    /**
       * A description of the column (will be presented as a title over the column header
       */
    description: _propTypes.default.string,
    /**
       * If provided, allows this column to be sorted on. Must return the value to sort against.
       */
    sortable: _propTypes.default.func,
    /**
       * A CSS width property. Hints for the required width of the column
       */
    width: _propTypes.default.string,
    /**
       * Indicates whether this column should truncate its content when it doesn't fit
       */
    truncateText: _propTypes.default.bool,
    isExpander: _propTypes.default.bool,
    align: _propTypes.default.any,
    /**
       * Disables the user's ability to change the sort but still shows the current direction
       */
    readOnly: _propTypes.default.bool,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired, _propTypes.default.shape({
    /**
       * An array of one of the objects: #DefaultItemAction or #CustomItemAction
       */
    actions: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
      /**
         * The type of action
         */
      type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["button"]), _propTypes.default.oneOf(["icon"]).isRequired]),
      /**
         * Defines the color of the button
         */
      color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      name: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]).isRequired,
      /**
         * Describes the action (will render as tooltip content)
         */
      /**
         * Describes the action (will render as tooltip content)
         */
      description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]).isRequired,
      /**
         * A handler function to execute the action
         */
      /**
         * A handler function to execute the action
         */
      onClick: _propTypes.default.func,
      href: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]),
      target: _propTypes.default.string,
      /**
         * A callback function that determines whether the action is available
         */
      /**
         * A callback function that determines whether the action is available
         */
      available: _propTypes.default.func,
      /**
         * A callback function that determines whether the action is enabled
         */
      /**
         * A callback function that determines whether the action is enabled
         */
      enabled: _propTypes.default.func,
      isPrimary: _propTypes.default.bool,
      "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired]),
      /**
         * Associates an icon with the button
         */
      icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.func.isRequired])
    }).isRequired, _propTypes.default.shape({
      /**
         * Allows rendering a totally custom action
         */
      render: _propTypes.default.func.isRequired,
      /**
         * A callback that defines whether the action is available
         */
      available: _propTypes.default.func,
      /**
         * A callback that defines whether the action is enabled
         */
      enabled: _propTypes.default.func,
      isPrimary: _propTypes.default.bool
    }).isRequired]).isRequired).isRequired,
    /**
       * The display name of the column
       */
    name: _propTypes.default.node,
    /**
       * A description of the column (will be presented as a title over the column header
       */
    description: _propTypes.default.string,
    /**
       * A CSS width property. Hints for the required width of the column
       */
    width: _propTypes.default.string
  }).isRequired]).isRequired),
  /**
     * Error message to display
     */
  /**
     * Error message to display
     */
  error: _propTypes.default.string,
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  tableCaption: _propTypes.default.string,
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  rowHeader: _propTypes.default.string,
  hasActions: _propTypes.default.bool,
  isExpandable: _propTypes.default.bool,
  isSelectable: _propTypes.default.bool,
  /**
     * Provides an infinite loading indicator
     */
  /**
     * Provides an infinite loading indicator
     */
  loading: _propTypes.default.bool,
  /**
     * If true, will convert table to cards in mobile view
     */
  /**
     * If true, will convert table to cards in mobile view
     */
  responsive: _propTypes.default.bool,
  /**
     * Applied to `EuiTableRow`
     */
  /**
     * Applied to `EuiTableRow`
     */
  rowProps: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.func.isRequired]),
  /**
     * Configures #EuiTableSelectionType
     */
  /**
     * Configures #EuiTableSelectionType
     */
  selection: _propTypes.default.shape({
    /**
       * A callback that will be called whenever the item selection changes.
       *
       * Required if `selected` is passed.
       */
    onSelectionChange: _propTypes.default.func,
    /**
       * A callback that is called per item to indicate whether it is selectable
       */
    selectable: _propTypes.default.func,
    /**
       * A callback that is called per item to retrieve a message for its selectable state.
       * We display these messages as a tooltip on an unselectable checkbox
       */
    selectableMessage: _propTypes.default.func,
    /**
       * Sets initially selected items. Use for uncontrolled selection behavior (checkbox
       * will only change from user input, and not from developer control).
       *
       * This prop will be ignored if `selected` is passed.
       */
    initialSelected: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /**
       * Used for controlled selection behavior, e.g. when you want to programmatically
       * control which selection checkboxes are checked, and which are not.
       */
    selected: _propTypes.default.arrayOf(_propTypes.default.any.isRequired)
  }),
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  tableLayout: _propTypes.default.oneOf(["fixed", "auto"]),
  /**
     * Applied to table cells. Any cell using a render function will set this to be false.
     *
     * Creates a text wrapper around cell content that helps word break or truncate
     * long text correctly.
     */
  /**
     * Applied to table cells. Any cell using a render function will set this to be false.
     *
     * Creates a text wrapper around cell content that helps word break or truncate
     * long text correctly.
     */
  textOnly: _propTypes.default.bool,
  message: _propTypes.default.node,
  /**
     * Configures #Search.
     */
  /**
     * Configures #Search.
     */
  search: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    onChange: _propTypes.default.func,
    /**
       The initial query the bar will hold when first mounted
       */
    defaultQuery: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
    /**
       If you wish to use the search bar as a controlled component, continuously pass the query via this prop.
       */
    query: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
    /**
       Configures the search box. Set `placeholder` to change the placeholder text in the box and `incremental` to support incremental (as you type) search.
       */
    box: _propTypes.default.shape({
      name: _propTypes.default.string,
      id: _propTypes.default.string,
      placeholder: _propTypes.default.string,
      value: _propTypes.default.string,
      isInvalid: _propTypes.default.bool,
      /**
         * Expand to fill 100% of the parent.
         * Defaults to `fullWidth` prop of `<EuiForm>`.
         * @default false
         */
      fullWidth: _propTypes.default.bool,
      isLoading: _propTypes.default.bool,
      /**
         * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
         * If you don't need the on[Enter] functionality, prefer using onChange
         */
      onSearch: _propTypes.default.func,
      /**
         * When `true` the search will be executed (that is, the `onSearch` will be called) as the
         * user types.
         */
      incremental: _propTypes.default.bool,
      /**
         * when `true` creates a shorter height input
         */
      compressed: _propTypes.default.bool,
      inputRef: _propTypes.default.func,
      /**
         * Shows a button that quickly clears any input
         */
      isClearable: _propTypes.default.bool,
      /**
         * Creates an input group with element(s) coming before input
         * `string` | `ReactElement` or an array of these
         */
      prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
      /**
         * Creates an input group with element(s) coming after input.
         * `string` | `ReactElement` or an array of these
         */
      append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      // Boolean values are not meaningful to this EuiSearchBox, but are allowed so that other
      // components can use e.g. a true value to mean "auto-derive a schema". See EuiInMemoryTable.
      // Admittedly, this is a bit of a hack.
      schema: _propTypes.default.oneOfType([_propTypes.default.shape({
        strict: _propTypes.default.bool,
        fields: _propTypes.default.any,
        flags: _propTypes.default.arrayOf(_propTypes.default.string.isRequired)
      }).isRequired, _propTypes.default.bool.isRequired])
    }),
    /**
       An array of search filters. See #SearchFilterConfig.
       */
    filters: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
      type: _propTypes.default.oneOf(["is"]).isRequired,
      field: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired,
      negatedName: _propTypes.default.string,
      available: _propTypes.default.func
    }).isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
      field: _propTypes.default.string,
      name: _propTypes.default.string.isRequired,
      /**
         * See #FieldValueOptionType
         */
      options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
        field: _propTypes.default.string,
        value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
          type: _propTypes.default.oneOf(["date"]).isRequired,
          raw: _propTypes.default.any.isRequired,
          granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
            es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
            js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
            isSame: _propTypes.default.func.isRequired,
            start: _propTypes.default.func.isRequired,
            startOfNext: _propTypes.default.func.isRequired,
            iso8601: _propTypes.default.func.isRequired
          }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
          text: _propTypes.default.string.isRequired,
          resolve: _propTypes.default.func.isRequired
        }).isRequired]).isRequired,
        name: _propTypes.default.string,
        view: _propTypes.default.node
      }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
      filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
      cache: _propTypes.default.number,
      multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
      loadingMessage: _propTypes.default.string,
      noOptionsMessage: _propTypes.default.string,
      searchThreshold: _propTypes.default.number,
      available: _propTypes.default.func,
      autoClose: _propTypes.default.bool,
      operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["field_value_toggle"]).isRequired,
      field: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string.isRequired,
      negatedName: _propTypes.default.string,
      available: _propTypes.default.func,
      operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["field_value_toggle_group"]).isRequired,
      field: _propTypes.default.string.isRequired,
      /**
         * See #FieldValueToggleGroupFilterItemType
         */
      items: _propTypes.default.arrayOf(_propTypes.default.shape({
        value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired]).isRequired,
        name: _propTypes.default.string.isRequired,
        negatedName: _propTypes.default.string,
        operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
      }).isRequired).isRequired,
      available: _propTypes.default.func
    }).isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["custom_component"]).isRequired,
      component: _propTypes.default.elementType.isRequired,
      available: _propTypes.default.func
    }).isRequired]).isRequired),
    /**
       * Tools which go to the left of the search bar.
       */
    toolsLeft: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),
    /**
       * Tools which go to the right of the search bar.
       */
    toolsRight: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),
    /**
       * Date formatter to use when parsing date values
       */
    dateFormat: _propTypes.default.any,
    /**
       * Hint to render below the search bar
       */
    hint: _propTypes.default.shape({
      content: _propTypes.default.node.isRequired,
      popoverProps: _propTypes.default.any
    }),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired]),
  /**
     * By default, tables use `eql` format for search which allows using advanced filters.
     *
     * However, certain special characters (such as quotes, parentheses, and colons)
     * are reserved for EQL syntax and will error if used.
     * If your table does not require filter search and instead requires searching for certain
     * symbols, use a plain `text` search format instead (note that filters will be ignored
     * in this format).
     *
     * @default "eql"
     */
  /**
     * By default, tables use `eql` format for search which allows using advanced filters.
     *
     * However, certain special characters (such as quotes, parentheses, and colons)
     * are reserved for EQL syntax and will error if used.
     * If your table does not require filter search and instead requires searching for certain
     * symbols, use a plain `text` search format instead (note that filters will be ignored
     * in this format).
     *
     * @default "eql"
     */
  searchFormat: _propTypes.default.oneOf(["eql", "text"]),
  /**
     * Configures #Pagination
     */
  pagination: _propTypes.default.oneOfType([_propTypes.default.oneOf([undefined]), _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    pageSizeOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),
    initialPageIndex: _propTypes.default.number,
    initialPageSize: _propTypes.default.number,
    pageIndex: _propTypes.default.number,
    pageSize: _propTypes.default.number,
    /**
       * Option to completely hide the "Rows per page" selector.
       *
       * @default true
       */
    showPerPageOptions: _propTypes.default.bool,
    /**
       * Current selection for "Rows per page".
       * Pass `0` to display the selected "Show all" option and hide the pagination.
       *
       * @default 10
       */
    itemsPerPage: _propTypes.default.number,
    /**
       * Custom array of options for "Rows per page".
       * Pass `0` as one of the options to create a "Show all" option.
       *
       * @default [10, 25, 50]
       */
    itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),
    /**
       * Click handler that passes back selected `pageSize` number
       */
    onChangeItemsPerPage: _propTypes.default.func,
    onChangePage: _propTypes.default.func,
    /**
       * Requires the `id` of the table being controlled
       */
    "aria-controls": _propTypes.default.string,
    "aria-label": _propTypes.default.string
  }).isRequired])]),
  /**
     * Configures #EuiTableSortingType
     */
  /**
     * Configures #EuiTableSortingType
     */
  sorting: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    sort: _propTypes.default.any.isRequired
  }).isRequired]),
  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */
  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */
  allowNeutralSort: _propTypes.default.bool,
  /**
     * `onChange` is not required when `pagination` and/or `sorting` are configured,
     * but if `onChange` is present it is responsible for handling state for each/both.
     * See #Criteria or #CriteriaWithPagination
     */
  /**
     * `onChange` is not required when `pagination` and/or `sorting` are configured,
     * but if `onChange` is present it is responsible for handling state for each/both.
     * See #Criteria or #CriteriaWithPagination
     */
  onChange: _propTypes.default.any,
  /**
     * Callback for when table pagination or sorting is changed. This is meant to be informational only, and not used to set any state as the in-memory table already manages this state. See #Criteria or #CriteriaWithPagination.
     */
  onTableChange: _propTypes.default.func,
  executeQueryOptions: _propTypes.default.shape({
    defaultFields: _propTypes.default.arrayOf(_propTypes.default.string.isRequired),
    isClauseMatcher: _propTypes.default.func,
    explain: _propTypes.default.bool,
    /**
         * When the search bar Query is controlled and passed to the `search` prop it is by default executed against the items passed to the table to filter them out.
         * If the filtering is already done before passing the `items` to the table we can disable the execution by setting `enabled` to `false`.
         */
    enabled: _propTypes.default.bool
  }),
  /**
     * Insert content between the search bar and table components.
     */
  /**
     * Insert content between the search bar and table components.
     */
  childrenBetween: _propTypes.default.node
};