"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultItemAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _predicate = require("../../services/predicate");
var _button = require("../button");
var _tool_tip = require("../tool_tip");
var _accessibility = require("../../services/accessibility");
var _accessibility2 = require("../accessibility");
var _action_types = require("./action_types");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var DefaultItemAction = function DefaultItemAction(_ref) {
  var action = _ref.action,
    enabled = _ref.enabled,
    item = _ref.item,
    className = _ref.className;
  if (!action.onClick && !action.href) {
    throw new Error("Cannot render item action [".concat(action.name, "]. Missing required 'onClick' callback\n      or 'href' string. If you want to provide a custom action control, make sure to define the 'render' callback"));
  }
  var onClick = action.onClick ? function () {
    return action.onClick(item);
  } : undefined;
  var buttonColor = action.color;
  var color = 'primary';
  if (buttonColor) {
    color = (0, _predicate.isString)(buttonColor) ? buttonColor : buttonColor(item);
  }
  var buttonIcon = action.icon;
  var icon;
  if (buttonIcon) {
    icon = (0, _predicate.isString)(buttonIcon) ? buttonIcon : buttonIcon(item);
  }
  var button;
  var actionContent = (0, _action_types.callWithItemIfFunction)(item)(action.name);
  var tooltipContent = (0, _action_types.callWithItemIfFunction)(item)(action.description);
  var href = (0, _action_types.callWithItemIfFunction)(item)(action.href);
  var dataTestSubj = (0, _action_types.callWithItemIfFunction)(item)(action['data-test-subj']);
  var ariaLabelId = (0, _accessibility.useGeneratedHtmlId)();
  var ariaLabelledBy;
  if (action.type === 'icon') {
    if (!icon) {
      throw new Error("Cannot render item action [".concat(action.name, "]. It is configured to render as an icon but no\n      icon is provided. Make sure to set the 'icon' property of the action"));
    }
    button = (0, _react2.jsx)(_button.EuiButtonIcon, {
      className: className,
      "aria-labelledby": ariaLabelId,
      isDisabled: !enabled,
      color: color,
      iconType: icon,
      onClick: onClick,
      href: href,
      target: action.target,
      "data-test-subj": dataTestSubj
      // If action is disabled, the normal tooltip can't show - attempt to
      // provide some amount of affordance with a browser title tooltip
      ,
      title: !enabled ? tooltipContent : undefined
    });
    // actionContent (action.name) is a ReactNode and must be rendered
    // to an element and referenced by ID for screen readers
    ariaLabelledBy = (0, _react2.jsx)(_accessibility2.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", {
      id: ariaLabelId
    }, actionContent));
  } else {
    button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
      className: className,
      size: "s",
      isDisabled: !enabled,
      color: color,
      iconType: icon,
      onClick: onClick,
      href: href,
      target: action.target,
      "data-test-subj": dataTestSubj,
      flush: "right"
    }, actionContent);
  }
  return enabled ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: tooltipContent,
    delay: "long"
  }, button), ariaLabelledBy) : (0, _react2.jsx)(_react.default.Fragment, null, button, ariaLabelledBy);
};
exports.DefaultItemAction = DefaultItemAction;