"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("./basic_table");
var _button = require("../button");
var _health = require("../health");
var _link = require("../link");
var _accessibility = require("../accessibility");
var _services = require("../../services");
var _faker = require("@faker-js/faker");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var users = [];
for (var i = 0; i < 20; i++) {
  users.push({
    id: i + 1,
    firstName: _faker.faker.person.firstName(),
    lastName: _faker.faker.person.lastName(),
    github: _faker.faker.internet.userName(),
    dateOfBirth: _faker.faker.date.past(),
    online: _faker.faker.datatype.boolean(),
    location: {
      city: _faker.faker.location.city(),
      country: _faker.faker.location.country()
    }
  });
}
var columns = [{
  field: 'firstName',
  name: 'First Name',
  sortable: true,
  truncateText: true,
  mobileOptions: {
    render: function render(user) {
      return (0, _react2.jsx)("span", null, user.firstName, " ", user.lastName);
    },
    header: false,
    truncateText: false,
    enlarge: true,
    width: '100%'
  }
}, {
  field: 'lastName',
  name: 'Last Name',
  truncateText: true,
  mobileOptions: {
    show: false
  }
}, {
  field: 'github',
  name: 'Github',
  render: function render(username) {
    return (0, _react2.jsx)(_link.EuiLink, {
      href: "#",
      target: "_blank"
    }, username);
  }
}, {
  field: 'dateOfBirth',
  name: 'Date of Birth',
  dataType: 'date',
  render: function render(dateOfBirth) {
    return (0, _services.formatDate)(dateOfBirth, 'dobLong');
  },
  sortable: true
}, {
  field: 'location',
  name: 'Location',
  truncateText: true,
  textOnly: true,
  render: function render(location) {
    return "".concat(location.city, ", ").concat(location.country);
  }
}, {
  field: 'online',
  name: 'Online',
  dataType: 'boolean',
  render: function render(online) {
    var color = online ? 'success' : 'danger';
    var label = online ? 'Online' : 'Offline';
    return (0, _react2.jsx)(_health.EuiHealth, {
      color: color
    }, label);
  },
  sortable: true,
  mobileOptions: {
    show: false
  }
}];
describe('EuiTable', function () {
  var BasicTable = function BasicTable() {
    return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
      tableCaption: "Demo of EuiBasicTable",
      columns: columns,
      items: users,
      "data-test-subj": "cy-basic-table"
    });
  };
  describe('Basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(1024, 768); // medium breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Mobile basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(375, 667); // small breakpoint
        cy.realMount((0, _react2.jsx)(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Expandable rows', function () {
    var ExpandableRowTable = function ExpandableRowTable() {
      var _useState = (0, _react.useState)({}),
        _useState2 = _slicedToArray(_useState, 2),
        itemIdToExpandedRowMap = _useState2[0],
        setItemIdToExpandedRowMap = _useState2[1];
      var toggleDetails = function toggleDetails(user) {
        var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
        if (itemIdToExpandedRowMapValues[user.id]) {
          delete itemIdToExpandedRowMapValues[user.id];
        } else {
          itemIdToExpandedRowMapValues[user.id] = (0, _react2.jsx)("div", null, (0, _react2.jsx)("p", null, "Location: ".concat(user.location.city)), (0, _react2.jsx)("p", null, "This person is online."));
        }
        setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
      };
      var columnsWithExpandingRowToggle = [].concat(columns, [{
        align: 'right',
        width: '40px',
        isExpander: true,
        name: (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, "Expand rows")),
        render: function render(user) {
          var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
          return (0, _react2.jsx)(_button.EuiButtonIcon, {
            id: user.id.toString(),
            onClick: function onClick() {
              return toggleDetails(user);
            },
            "aria-label": itemIdToExpandedRowMapValues[user.id] ? 'Collapse' : 'Expand',
            iconType: itemIdToExpandedRowMapValues[user.id] ? 'arrowDown' : 'arrowRight'
          });
        }
      }]);
      return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
        tableCaption: "Demo of EuiBasicTable with expanding rows",
        itemIdToExpandedRowMap: itemIdToExpandedRowMap,
        isExpandable: true,
        columns: columnsWithExpandingRowToggle,
        items: users,
        itemId: "id",
        "data-test-subj": "cy-expandable-row-table"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount((0, _react2.jsx)(ExpandableRowTable, null));
      cy.get('[data-test-subj="cy-expandable-row-table"]').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility', function () {
      it('has zero violations after expanding a row', function () {
        cy.get('button#1').focus();
        cy.realPress('Enter');
        cy.get('tr.euiTableRow-isExpandedRow div.euiTableCellContent').should('exist');
        cy.checkAxe();
      });
    });
  });
});