"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiAvatarStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _avatarSize = function _avatarSize(_ref7) {
  var size = _ref7.size,
    fontSize = _ref7.fontSize;
  return "\n    ".concat((0, _global_styling.logicalCSS)('width', size), ";\n    ").concat((0, _global_styling.logicalCSS)('height', size), ";\n    line-height: ").concat(size, ";\n    font-size: ").concat(fontSize, ";\n  ");
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "4wfy2n-none",
  styles: "text-transform:none;label:none;"
} : {
  name: "4wfy2n-none",
  styles: "text-transform:none;label:none;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "5xhpzh-lowercase",
  styles: "text-transform:lowercase;label:lowercase;"
} : {
  name: "5xhpzh-lowercase",
  styles: "text-transform:lowercase;label:lowercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;"
} : {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "mxeh3g-capitalize",
  styles: "text-transform:capitalize;label:capitalize;"
} : {
  name: "mxeh3g-capitalize",
  styles: "text-transform:capitalize;label:capitalize;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "14sj6wh-isDisabled",
  styles: "cursor:not-allowed;filter:grayscale(100%);label:isDisabled;"
} : {
  name: "14sj6wh-isDisabled",
  styles: "cursor:not-allowed;filter:grayscale(100%);label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref6 = process.env.NODE_ENV === "production" ? {
  name: "ont6vs-user",
  styles: "border-radius:50%;label:user;"
} : {
  name: "ont6vs-user",
  styles: "border-radius:50%;label:user;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAvatarStyles = function euiAvatarStyles(_ref8) {
  var euiTheme = _ref8.euiTheme;
  return {
    // Base
    euiAvatar: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-flex;justify-content:center;align-items:center;vertical-align:middle;background-size:cover;background-color:", euiTheme.colors.lightShade, ";", (0, _global_styling.logicalTextAlignCSS)('center'), " ", (0, _global_styling.logicalCSS)('overflow-x', 'hidden'), "font-weight:", euiTheme.font.weight.medium, ";;label:euiAvatar;"),
    // Variants
    plain: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.emptyShade, ";;label:plain;"),
    subdued: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.lightestShade, ";;label:subdued;"),
    user: _ref6,
    space: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:space;"),
    // States
    isDisabled: _ref5,
    // Sizes
    s: /*#__PURE__*/(0, _react.css)(_avatarSize({
      size: euiTheme.size.l,
      fontSize: euiTheme.size.m
    }), ";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(_avatarSize({
      size: euiTheme.size.xl,
      fontSize: "calc(".concat(euiTheme.size.base, " * 0.9)")
    }), ";label:m;"),
    l: /*#__PURE__*/(0, _react.css)(_avatarSize({
      size: euiTheme.size.xxl,
      fontSize: "calc(".concat(euiTheme.size.l, " * 0.8)")
    }), ";label:l;"),
    xl: /*#__PURE__*/(0, _react.css)(_avatarSize({
      size: "calc(".concat(euiTheme.size.base, " * 4)"),
      fontSize: "calc(".concat(euiTheme.size.xl, " * 0.8)")
    }), ";label:xl;"),
    // Casing
    capitalize: _ref4,
    uppercase: _ref3,
    lowercase: _ref2,
    none: _ref
  };
};
exports.euiAvatarStyles = euiAvatarStyles;